/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import org.apache.sis.feature.internal.Resources;

public enum Dimensions {
    XY(false, false, 2),
    XYZ(true, false, 3),
    XYM(false, true, 3),
    XYZM(true, true, 4);

    public final boolean hasZ;
    public final boolean hasM;
    public final byte count;

    private Dimensions(boolean hasZ, boolean hasM, byte count) {
        this.hasZ = hasZ;
        this.hasM = hasM;
        this.count = count;
    }

    public static Dimensions forZorM(boolean hasZ, boolean hasM) {
        return hasZ ? (hasM ? XYZM : XYZ) : (hasM ? XYM : XY);
    }

    public static Dimensions forCount(int count, boolean preferM) {
        switch (count) {
            case 2: {
                return XY;
            }
            case 3: {
                return preferM ? XYM : XYZ;
            }
            case 4: {
                return XYZM;
            }
        }
        throw new IllegalArgumentException(Resources.format((short)76, count));
    }
}

