/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;

public abstract class PathBasedHolder
implements Comparable<PathBasedHolder> {
    protected final String fullPath;
    final String protocol;
    final String host;
    final String path;
    final ServiceReference<?> serviceReference;

    protected PathBasedHolder(String url, ServiceReference<?> serviceReference) {
        String newPath = url;
        String newHost = "";
        String newProtocol = "";
        if (newPath.startsWith("http://") || newPath.startsWith("https://")) {
            int idxProtocolEnd = newPath.indexOf("://");
            newProtocol = newPath.substring(0, idxProtocolEnd);
            newPath = newPath.substring(idxProtocolEnd + 1);
        }
        if (newPath.startsWith("//")) {
            int idxHostEnd = newPath.indexOf("/", 2);
            int n = idxHostEnd = idxHostEnd == -1 ? newPath.length() : idxHostEnd;
            if (newPath.length() > 2) {
                newHost = newPath.substring(2, idxHostEnd);
                newPath = idxHostEnd < newPath.length() ? newPath.substring(idxHostEnd) : "/";
            } else {
                newPath = "/";
            }
        }
        this.fullPath = url;
        this.path = newPath;
        this.host = newHost;
        this.protocol = newProtocol;
        this.serviceReference = serviceReference;
    }

    String getProvider() {
        if (this.serviceReference == null) {
            return "Apache Sling Request Authenticator";
        }
        String descr = (String)Converters.standardConverter().convert(this.serviceReference.getProperty("service.description")).to(String.class);
        if (descr != null) {
            return descr;
        }
        String id = (String)((Converting)Converters.standardConverter().convert(this.serviceReference.getProperty("service.id")).defaultValue((Object)"unknown")).to(String.class);
        return "Service ".concat(id);
    }

    public boolean isPathRequiresHandler(String path) {
        if ("/".equals(this.path)) {
            return true;
        }
        int holderPathLength = this.path.length();
        if (path.length() < holderPathLength) {
            return false;
        }
        if (path.equals(this.path)) {
            return true;
        }
        return path.startsWith(this.path) && (path.charAt(holderPathLength) == '/' || path.charAt(holderPathLength) == '.');
    }

    @Override
    public int compareTo(PathBasedHolder other) {
        int pathResult = other.path.compareTo(this.path);
        if (pathResult != 0) {
            return pathResult;
        }
        if (this.serviceReference == null) {
            if (other.serviceReference == null) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            return -1;
        }
        if (other.serviceReference == null) {
            return 1;
        }
        int serviceResult = other.serviceReference.compareTo(this.serviceReference);
        if (serviceResult != 0) {
            return serviceResult;
        }
        return this.getClass().getName().compareTo(other.getClass().getName());
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            PathBasedHolder other = (PathBasedHolder)obj;
            return this.fullPath.equals(other.fullPath) && (this.serviceReference == null && other.serviceReference == null || this.serviceReference != null && this.serviceReference.equals(other.serviceReference));
        }
        return false;
    }
}

