/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.graphql.api.SlingTypeResolverEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeResolverEnvironmentWrapper
implements SlingTypeResolverEnvironment<GraphQLObjectType> {
    private final TypeResolutionEnvironment env;
    private final Resource currentResource;
    private final String options;
    private final String source;

    TypeResolverEnvironmentWrapper(TypeResolutionEnvironment env, Resource currentResource, String options, String source) {
        this.env = env;
        this.currentResource = currentResource;
        this.options = options;
        this.source = source;
    }

    @Override
    public Resource getCurrentResource() {
        return this.currentResource;
    }

    @Override
    public String getResolverOptions() {
        return this.options;
    }

    @Override
    public String getResolverSource() {
        return this.source;
    }

    @Override
    public Object getObject() {
        return this.env.getObject();
    }

    @Override
    @Nullable
    public GraphQLObjectType getObjectType(@NotNull String name) {
        return this.env.getSchema().getObjectType(name);
    }
}

