/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.testing.mock.sling.servlet;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.sling.MockSling;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

/**
 * Mock {@link org.apache.sling.api.SlingHttpServletRequest} implementation.
 *
 * @deprecated Use {@link MockSlingJakartaHttpServletRequest} instead.
 */
@Deprecated(since = "3.2.0")
public class MockSlingHttpServletRequest extends org.apache.sling.servlethelpers.MockSlingHttpServletRequest {

    /**
     * Instantiate with default resource resolver
     * @param bundleContext Bundle context
     */
    public MockSlingHttpServletRequest(@NotNull BundleContext bundleContext) {
        this(new MockSlingJakartaHttpServletRequest(MockSling.newResourceResolver(bundleContext), bundleContext));
    }

    /**
     * @param resourceResolver Resource resolver
     * @param bundleContext Bundle context
     */
    public MockSlingHttpServletRequest(
            @NotNull ResourceResolver resourceResolver, @NotNull BundleContext bundleContext) {
        this(new MockSlingJakartaHttpServletRequest(resourceResolver, bundleContext));
    }

    /**
     * @param jakartaRequest the jakarta request to wrap
     */
    public MockSlingHttpServletRequest(@NotNull MockSlingJakartaHttpServletRequest jakartaRequest) {
        super(jakartaRequest);
    }

    @Override
    protected @NotNull MockRequestPathInfo newMockRequestPathInfo() {
        return new MockRequestPathInfo(getResourceResolver());
    }

    @Override
    protected @NotNull MockHttpSession newMockHttpSession() {
        return new MockHttpSession(new MockJakartaHttpSession());
    }
}
