/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

final class TraversalSerializersV2 {
    private TraversalSerializersV2() {
    }

    static final class TraversalStrategyProxyJacksonDeserializer<T extends TraversalStrategy>
    extends AbstractObjectDeserializer<TraversalStrategyProxy> {
        private final Class<T> clazz;

        public TraversalStrategyProxyJacksonDeserializer(Class<T> clazz) {
            super(TraversalStrategyProxy.class);
            this.clazz = clazz;
        }

        @Override
        public TraversalStrategyProxy<T> createObject(Map<String, Object> data) {
            return new TraversalStrategyProxy<T>(this.clazz, (Configuration)new MapConfiguration(data));
        }
    }

    static class TraverserJacksonDeserializer
    extends StdDeserializer<Traverser> {
        public TraverserJacksonDeserializer() {
            super(Traverser.class);
        }

        public Traverser deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            long bulk = 1L;
            Object v = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("bulk")) {
                    jsonParser.nextToken();
                    bulk = (Long)deserializationContext.readValue(jsonParser, Long.class);
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                v = deserializationContext.readValue(jsonParser, Object.class);
            }
            return new DefaultRemoteTraverser<Object>(v, bulk);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class BindingJacksonDeserializer
    extends StdDeserializer<Bytecode.Binding> {
        public BindingJacksonDeserializer() {
            super(Bytecode.Binding.class);
        }

        public Bytecode.Binding deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String k = null;
            Object v = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("key")) {
                    jsonParser.nextToken();
                    k = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                v = deserializationContext.readValue(jsonParser, Object.class);
            }
            return new Bytecode.Binding<Object>(k, v);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class LambdaJacksonDeserializer
    extends StdDeserializer<Lambda> {
        public LambdaJacksonDeserializer() {
            super(Lambda.class);
        }

        public Lambda deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String script = null;
            String language = null;
            int arguments = -1;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("script")) {
                    jsonParser.nextToken();
                    script = jsonParser.getText();
                    continue;
                }
                if (jsonParser.getCurrentName().equals("language")) {
                    jsonParser.nextToken();
                    language = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("arguments")) continue;
                jsonParser.nextToken();
                arguments = jsonParser.getIntValue();
            }
            if (-1 == arguments || arguments > 2) {
                return new Lambda.UnknownArgLambda(script, language, arguments);
            }
            if (0 == arguments) {
                return new Lambda.ZeroArgLambda(script, language);
            }
            if (1 == arguments) {
                return new Lambda.OneArgLambda(script, language);
            }
            return new Lambda.TwoArgLambda(script, language);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class TextPJacksonDeserializer
    extends StdDeserializer<TextP> {
        public TextPJacksonDeserializer() {
            super(TextP.class);
        }

        public TextP deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String predicate = null;
            String value = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("predicate")) {
                    jsonParser.nextToken();
                    predicate = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value = (String)deserializationContext.readValue(jsonParser, String.class);
            }
            try {
                return (TextP)TextP.class.getMethod(predicate, String.class).invoke(null, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class PJacksonDeserializer
    extends StdDeserializer<P> {
        public PJacksonDeserializer() {
            super(P.class);
        }

        public P deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String predicate = null;
            Object value = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("predicate")) {
                    jsonParser.nextToken();
                    predicate = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value = deserializationContext.readValue(jsonParser, Object.class);
            }
            if (predicate.equals("and") || predicate.equals("or")) {
                return predicate.equals("and") ? new AndP((List)value) : new OrP((List)value);
            }
            if (predicate.equals("not") && value instanceof P) {
                return P.not((P)value);
            }
            try {
                if (value instanceof Collection) {
                    if (predicate.equals("between")) {
                        return P.between(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("inside")) {
                        return P.between(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("outside")) {
                        return P.outside(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("within")) {
                        return P.within((Collection)value);
                    }
                    if (predicate.equals("without")) {
                        return P.without((Collection)value);
                    }
                    return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value);
                }
                try {
                    return (P)P.class.getMethod(predicate, Object.class).invoke(null, value);
                }
                catch (NoSuchMethodException e) {
                    return (P)P.class.getMethod(predicate, Object[].class).invoke(null, new Object[]{new Object[]{value}});
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class EnumJacksonDeserializer<A extends Enum>
    extends StdDeserializer<A> {
        public EnumJacksonDeserializer(Class<A> enumClass) {
            super(enumClass);
        }

        public A deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Class enumClass = this._valueClass;
            String enumName = jsonParser.getText();
            for (Enum a : (Enum[])enumClass.getEnumConstants()) {
                if (!a.name().equals(enumName)) continue;
                return (A)a;
            }
            throw new IOException("Unknown enum type: " + enumClass);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class BytecodeJacksonDeserializer
    extends StdDeserializer<Bytecode> {
        public BytecodeJacksonDeserializer() {
            super(Bytecode.class);
        }

        public Bytecode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Bytecode bytecode = new Bytecode();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String current = jsonParser.getCurrentName();
                if (!current.equals("source") && !current.equals("step")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    jsonParser.nextToken();
                    String stepName = jsonParser.getText();
                    ArrayList<Object> arguments = new ArrayList<Object>();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        arguments.add(deserializationContext.readValue(jsonParser, Object.class));
                    }
                    if (current.equals("source")) {
                        bytecode.addSource(stepName, arguments.toArray());
                        continue;
                    }
                    bytecode.addStep(stepName, arguments.toArray());
                }
            }
            return bytecode;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class TraversalStrategyJacksonSerializer
    extends StdScalarSerializer<TraversalStrategy> {
        public TraversalStrategyJacksonSerializer() {
            super(TraversalStrategy.class);
        }

        public void serialize(TraversalStrategy traversalStrategy, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            for (Map.Entry entry : ConfigurationConverter.getMap((Configuration)traversalStrategy.getConfiguration()).entrySet()) {
                jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class TraverserJacksonSerializer
    extends StdScalarSerializer<Traverser> {
        public TraverserJacksonSerializer() {
            super(Traverser.class);
        }

        public void serialize(Traverser traverserInstance, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("bulk", (Object)traverserInstance.bulk());
            jsonGenerator.writeObjectField("value", traverserInstance.get());
            jsonGenerator.writeEndObject();
        }
    }

    static final class BindingJacksonSerializer
    extends StdScalarSerializer<Bytecode.Binding> {
        public BindingJacksonSerializer() {
            super(Bytecode.Binding.class);
        }

        public void serialize(Bytecode.Binding binding, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("key", binding.variable());
            jsonGenerator.writeObjectField("value", binding.value());
            jsonGenerator.writeEndObject();
        }
    }

    static final class LambdaJacksonSerializer
    extends StdScalarSerializer<Lambda> {
        public LambdaJacksonSerializer() {
            super(Lambda.class);
        }

        public void serialize(Lambda lambda, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("script", lambda.getLambdaScript());
            jsonGenerator.writeStringField("language", lambda.getLambdaLanguage());
            jsonGenerator.writeNumberField("arguments", lambda.getLambdaArguments());
            jsonGenerator.writeEndObject();
        }
    }

    static final class PJacksonSerializer
    extends StdScalarSerializer<P> {
        public PJacksonSerializer() {
            super(P.class);
        }

        public void serialize(P p, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("predicate", p.getPredicateName());
            if (p instanceof ConnectiveP) {
                jsonGenerator.writeArrayFieldStart("value");
                for (P predicate : ((ConnectiveP)p).getPredicates()) {
                    jsonGenerator.writeObject(predicate);
                }
                jsonGenerator.writeEndArray();
            } else if (p.getValue() instanceof Collection) {
                jsonGenerator.writeArrayFieldStart("value");
                for (Object object : (Collection)p.getValue()) {
                    jsonGenerator.writeObject(object);
                }
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeObjectField("value", p.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    static class EnumJacksonSerializer
    extends StdScalarSerializer<Enum> {
        public EnumJacksonSerializer() {
            super(Enum.class);
        }

        public void serialize(Enum enumInstance, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(enumInstance.name());
        }
    }

    static final class BytecodeJacksonSerializer
    extends StdScalarSerializer<Bytecode> {
        public BytecodeJacksonSerializer() {
            super(Bytecode.class);
        }

        public void serialize(Bytecode bytecode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            if (bytecode.getSourceInstructions().iterator().hasNext()) {
                jsonGenerator.writeArrayFieldStart("source");
                for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
                    jsonGenerator.writeStartArray();
                    jsonGenerator.writeString(instruction.getOperator());
                    for (Object argument : instruction.getArguments()) {
                        jsonGenerator.writeObject(argument);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndArray();
            }
            if (bytecode.getStepInstructions().iterator().hasNext()) {
                jsonGenerator.writeArrayFieldStart("step");
                for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
                    jsonGenerator.writeStartArray();
                    jsonGenerator.writeString(instruction.getOperator());
                    for (Object argument : instruction.getArguments()) {
                        jsonGenerator.writeObject(argument);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class TraversalJacksonSerializer
    extends StdSerializer<Traversal> {
        public TraversalJacksonSerializer() {
            super(Traversal.class);
        }

        public void serialize(Traversal traversal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)traversal.asAdmin().getBytecode());
        }

        public void serializeWithType(Traversal traversal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(traversal, jsonGenerator, serializerProvider);
        }
    }
}

