/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DiscardStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.AdjacentToIncidentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.CountStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.EarlyLimitStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.FilterRankingStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IncidentToAdjacentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.MatchPredicateStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RepeatUnrollStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class LazyBarrierStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    public static final String BARRIER_PLACEHOLDER = Graph.Hidden.hide("gremlin.lazyBarrier.position");
    public static final String BARRIER_COPY_LABELS = Graph.Hidden.hide("gremlin.lazyBarrier.copyLabels");
    private static final LazyBarrierStrategy INSTANCE = new LazyBarrierStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(CountStrategy.class, PathRetractionStrategy.class, IncidentToAdjacentStrategy.class, AdjacentToIncidentStrategy.class, FilterRankingStrategy.class, InlineFilterStrategy.class, MatchPredicateStrategy.class, EarlyLimitStrategy.class, RepeatUnrollStrategy.class));
    private static final int BIG_START_SIZE = 5;
    protected static final int MAX_BARRIER_SIZE = 2500;

    private LazyBarrierStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal) || traversal.getTraverserRequirements().contains((Object)TraverserRequirement.PATH) || TraversalHelper.hasStepOfAssignableClass(DropStep.class, traversal) || TraversalHelper.hasStepOfAssignableClass(ElementStep.class, traversal)) {
            return;
        }
        boolean foundFlatMap = false;
        boolean labeledPath = false;
        for (int i = 0; i < traversal.getSteps().size(); ++i) {
            Set<String> keepLabels;
            Step step = traversal.getSteps().get(i);
            if (step.getLabels().contains(BARRIER_PLACEHOLDER)) {
                TraversalHelper.insertAfterStep(new NoOpBarrierStep(traversal, 2500), step, traversal);
                step.removeLabel(BARRIER_PLACEHOLDER);
                if (step.getLabels().contains(BARRIER_COPY_LABELS)) {
                    step.removeLabel(BARRIER_COPY_LABELS);
                    TraversalHelper.copyLabels(step, step.getNextStep(), true);
                }
            }
            if (step instanceof PathProcessor && null != (keepLabels = ((PathProcessor)((Object)step)).getKeepLabels()) && keepLabels.isEmpty()) {
                labeledPath = false;
            }
            if (step instanceof FlatMapStep && (!(step instanceof VertexStepContract) || !((VertexStepContract)step).returnsEdge()) || step instanceof GraphStepContract && (i > 0 || ((GraphStepContract)step).getIds().length >= 5 || ((GraphStepContract)step).getIds().length == 0 && !(step.getNextStep() instanceof HasStep))) {
                if (!(!foundFlatMap || labeledPath || step.getNextStep() instanceof Barrier || step.getNextStep() instanceof DiscardStep || step.getNextStep() instanceof EmptyStep || step.getNextStep() instanceof ProfileSideEffectStep)) {
                    NoOpBarrierStep noOpBarrierStep = new NoOpBarrierStep(traversal, 2500);
                    TraversalHelper.copyLabels(step, noOpBarrierStep, true);
                    TraversalHelper.insertAfterStep(noOpBarrierStep, step, traversal);
                } else {
                    foundFlatMap = true;
                }
            }
            if (step.getLabels().isEmpty()) continue;
            labeledPath = true;
        }
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static LazyBarrierStrategy instance() {
        return INSTANCE;
    }
}

