/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;

public class GraphBinaryReader {
    private final TypeSerializerRegistry registry;

    public GraphBinaryReader() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryReader(TypeSerializerRegistry registry) {
        this.registry = registry;
    }

    public <T> T readValue(Buffer buffer, Class<T> type, boolean nullable) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        TypeSerializer<T> serializer = this.registry.getSerializer(type);
        return serializer.readValue(buffer, this, nullable);
    }

    public <T> T read(Buffer buffer) throws IOException {
        TypeSerializer serializer;
        DataType type = DataType.get(Byte.toUnsignedInt(buffer.readByte()));
        if (type == DataType.UNSPECIFIED_NULL) {
            byte check = buffer.readByte();
            assert (check == 1);
            return null;
        }
        if (type != DataType.CUSTOM) {
            serializer = this.registry.getSerializer(type);
        } else {
            String customTypeName = this.readValue(buffer, String.class, false);
            serializer = this.registry.getSerializerForCustomType(customTypeName);
        }
        return (T)serializer.read(buffer, this);
    }
}

