/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;

public class GValueHelper {
    private GValueHelper() {
    }

    public static Map<Object, List<Object>> resolveProperties(Map<Object, List<Object>> properties) {
        return GValueHelper.resolveProperties(properties, null);
    }

    public static Map<Object, List<Object>> resolveProperties(Map<Object, List<Object>> properties, Consumer<GValue<?>> gValueConsumer) {
        HashMap<Object, List<Object>> unboxedProperties = new HashMap<Object, List<Object>>();
        properties.forEach((k, values) -> {
            ArrayList unboxedValues = new ArrayList();
            values.forEach(v -> {
                if (v instanceof GValue) {
                    GValue gValue = (GValue)v;
                    if (gValueConsumer != null) {
                        gValueConsumer.accept(gValue);
                    }
                    unboxedValues.add(gValue.get());
                } else {
                    unboxedValues.add(v);
                }
            });
            unboxedProperties.put(k, unboxedValues);
        });
        return unboxedProperties;
    }

    public static Set<GValue<?>> getGValuesFromProperties(Map<Object, List<Object>> properties) {
        return properties.values().stream().flatMap(Collection::stream).filter(propertyVal -> propertyVal instanceof GValue && ((GValue)propertyVal).isVariable()).map(obj -> (GValue)obj).collect(Collectors.toCollection(HashSet::new));
    }
}

