/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.util.proxy.ProxyFactory;

public class Jdk13ProxyFactory
implements ProxyFactory {
    @Override
    public void init(Properties props) throws OpenEJBException {
    }

    @Override
    public InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        return Proxy.getInvocationHandler(proxy);
    }

    @Override
    public Class getProxyClass(Class interfce) throws IllegalArgumentException {
        return Proxy.getProxyClass(interfce.getClassLoader(), interfce);
    }

    @Override
    public Class getProxyClass(Class[] interfaces) throws IllegalArgumentException {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("It's boring to implement 0 interfaces!");
        }
        return Proxy.getProxyClass(interfaces[0].getClassLoader(), interfaces);
    }

    @Override
    public boolean isProxyClass(Class cl) {
        return Proxy.isProxyClass(cl);
    }

    @Override
    public Object newProxyInstance(Class interfce, InvocationHandler h) throws IllegalArgumentException {
        try {
            return Proxy.newProxyInstance(interfce.getClassLoader(), new Class[]{interfce}, h);
        }
        catch (IllegalArgumentException iae) {
            ClassLoader reconciliatedCl = Jdk13ProxyFactory.reconciliate(interfce);
            try {
                reconciliatedCl.loadClass(interfce.getName());
                return Proxy.newProxyInstance(reconciliatedCl, new Class[]{interfce}, h);
            }
            catch (ClassNotFoundException e2) {
                throw iae;
            }
        }
    }

    @Override
    public Object newProxyInstance(Class[] interfaces, InvocationHandler handler) throws IllegalArgumentException {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("It's boring to implement 0 interfaces!");
        }
        try {
            return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, handler);
        }
        catch (IllegalArgumentException e) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> tcclHomeClass = tccl.loadClass(interfaces[0].getName());
                if (tcclHomeClass == interfaces[0]) {
                    return Proxy.newProxyInstance(tccl, interfaces, handler);
                }
            }
            catch (ClassNotFoundException e1) {
                ClassLoader reconciliatedCl = Jdk13ProxyFactory.reconciliate(interfaces);
                try {
                    Class<?> homeClass = reconciliatedCl.loadClass(interfaces[0].getName());
                    if (homeClass == interfaces[0]) {
                        return Proxy.newProxyInstance(reconciliatedCl, interfaces, handler);
                    }
                }
                catch (ClassNotFoundException e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private static ClassLoader reconciliate(Class<?> ... interfaces) {
        LinkedHashSet<ClassLoader> classloaders = new LinkedHashSet<ClassLoader>();
        for (Class<?> clazz : interfaces) {
            classloaders.add(clazz.getClassLoader());
        }
        return new MultipleClassLoadersClassLoader(classloaders.toArray(new ClassLoader[classloaders.size()]));
    }

    private static class MultipleClassLoadersClassLoader
    extends ClassLoader {
        private final ClassLoader[] delegatingClassloaders;

        public MultipleClassLoadersClassLoader(ClassLoader[] classLoaders) {
            super(classLoaders[0]);
            this.delegatingClassloaders = classLoaders;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            ClassNotFoundException ex = null;
            for (ClassLoader cl : this.delegatingClassloaders) {
                try {
                    return cl.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    if (ex != null) continue;
                    ex = cnfe;
                }
            }
            throw ex;
        }
    }
}

