/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.jsl;

import jakarta.batch.operations.BatchRuntimeException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.batchee.container.jsl.JSLValidationEventHandler;
import org.apache.batchee.container.jsl.Xsds;
import org.apache.batchee.jaxb.JSLJob;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class JobModelResolver {
    private static final JAXBContext JOB_CONTEXT;

    private JSLJob unmarshalJobXML(String jobXML) {
        JSLJob result;
        JSLValidationEventHandler handler = new JSLValidationEventHandler();
        try (ByteArrayInputStream is = new ByteArrayInputStream(jobXML.getBytes(StandardCharsets.UTF_8));){
            InputSource src = new InputSource(is);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            Unmarshaller u = JOB_CONTEXT.createUnmarshaller();
            u.setSchema(Xsds.jobXML());
            u.setEventHandler((ValidationEventHandler)handler);
            JakartaFilter xmlFilter = new JakartaFilter(parser.getXMLReader());
            xmlFilter.setContentHandler((ContentHandler)u.getUnmarshallerHandler());
            result = (JSLJob)u.unmarshal((Source)new SAXSource(xmlFilter, src), JSLJob.class).getValue();
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Exception unmarshalling jobXML", e);
        }
        if (handler.eventOccurred()) {
            throw new IllegalArgumentException("xJCL invalid per schema");
        }
        return result;
    }

    public JSLJob resolveModel(final String jobXML) {
        if (System.getSecurityManager() == null) {
            return this.unmarshalJobXML(jobXML);
        }
        return AccessController.doPrivileged(new PrivilegedAction<JSLJob>(){

            @Override
            public JSLJob run() {
                return JobModelResolver.this.unmarshalJobXML(jobXML);
            }
        });
    }

    static {
        try {
            JOB_CONTEXT = JAXBContext.newInstance((String)JSLJob.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }

    private static class JakartaFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public JakartaFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        private String fixUri(String uri) {
            if ("http://xmlns.jcp.org/xml/ns/javaee".equals(uri) || "http://jakarta.ee/xml/ns/jakartaee".equals(uri)) {
                return "https://jakarta.ee/xml/ns/jakartaee";
            }
            return uri;
        }

        private Attributes fixVersion(String localName, Attributes atts) {
            if (localName.equals("job") && atts.getIndex("version") != -1 && !atts.getValue(atts.getIndex("version")).equals("2.0")) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.setValue(newAtts.getIndex("version"), "2.0");
                return newAtts;
            }
            return atts;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(this.fixUri(uri), localName, qName, this.fixVersion(localName, atts));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(this.fixUri(uri), localName, qName);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return EMPTY_INPUT_SOURCE;
        }
    }
}

