/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.Environment;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.MacNewLine;
import com.strobel.decompiler.languages.java.ast.NewLineType;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.UnixNewLine;
import com.strobel.decompiler.languages.java.ast.WindowsNewLine;
import com.strobel.decompiler.patterns.Role;

public abstract class NewLineNode
extends AstNode {
    private final TextLocation _startLocation;
    private final TextLocation _endLocation;

    protected NewLineNode() {
        this(TextLocation.EMPTY);
    }

    protected NewLineNode(TextLocation startLocation) {
        this._startLocation = startLocation != null ? startLocation : TextLocation.EMPTY;
        this._endLocation = new TextLocation(this._startLocation.line() + 1, 1);
    }

    public abstract NewLineType getNewLineType();

    @Override
    public TextLocation getStartLocation() {
        return this._startLocation;
    }

    @Override
    public TextLocation getEndLocation() {
        return this._endLocation;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitNewLine(this, data);
    }

    public Role<? extends NewLineNode> getRole() {
        return super.getRole();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHITESPACE;
    }

    public static NewLineNode create() {
        if (Environment.isWindows() || Environment.isOS2()) {
            return new WindowsNewLine();
        }
        if (Environment.isMac()) {
            return new MacNewLine();
        }
        return new UnixNewLine();
    }
}

