/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.lib.io.ByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer bb;

    public ByteBufferOutputStream() {
        this(4096);
    }

    public ByteBufferOutputStream(int size) {
        this.bb = ByteBuffer.allocate(size);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer obb = this.bb.duplicate();
        obb.flip();
        return obb;
    }

    public byte[] toByteArray() {
        ByteBuffer obb = this.toByteBuffer();
        int len = obb.remaining();
        byte[] result = new byte[len];
        obb.get(result, 0, len);
        return result;
    }

    private ByteBuffer bb(int len) {
        ByteBuffer obb = this.bb;
        if (obb.remaining() - len >= 0) {
            return obb;
        }
        int minCap = obb.position() + len;
        int newCap = obb.capacity() << 1;
        if (newCap - minCap < 0) {
            newCap = minCap;
        }
        obb.flip();
        this.bb = ByteBuffer.allocate(newCap).put(obb);
        return this.bb;
    }

    @Override
    public void write(int b) {
        this.bb(1).put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        int len = b.length;
        this.bb(len).put(b, 0, len);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.bb(len).put(b, off, len);
    }

    public void write(ByteBuffer src) {
        this.bb(src.remaining()).put(src);
    }

    public void write(InputStream in) throws IOException {
        ByteBuffer obb;
        if (in instanceof ByteBufferInputStream) {
            ByteBufferInputStream bbin = (ByteBufferInputStream)in;
            this.write(bbin.buffer());
            return;
        }
        do {
            int position;
            int size;
            obb = this.bb(in.available() + 1);
            byte[] buffer = obb.array();
            while (obb.hasRemaining() && (size = in.read(buffer, position = obb.position(), obb.remaining())) > 0) {
                obb.position(position + size);
            }
        } while (!obb.hasRemaining());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.bb.position());
        sb.append(" lim=");
        sb.append(this.bb.limit());
        sb.append(" cap=");
        sb.append(this.bb.capacity());
        sb.append("]");
        return sb.toString();
    }
}

