/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.micrometer.provider;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Optional;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.metrics.micrometer.provider.ExceptionClassProvider;
import org.apache.cxf.metrics.micrometer.provider.StandardTags;
import org.apache.cxf.metrics.micrometer.provider.TagsProvider;

public class StandardTagsProvider
implements TagsProvider {
    private final ExceptionClassProvider exceptionClassProvider;
    private final StandardTags standardTags;

    public StandardTagsProvider(ExceptionClassProvider exceptionClassProvider, StandardTags standardTags) {
        this.exceptionClassProvider = exceptionClassProvider;
        this.standardTags = standardTags;
    }

    @Override
    public Iterable<Tag> getTags(Exchange ex, boolean client) {
        Message request = this.getRequest(ex, client);
        Message response = this.getResponse(ex, client);
        Class<?> exception = this.exceptionClassProvider.getExceptionClass(ex, client);
        return Tags.of((Tag[])new Tag[]{this.standardTags.method(request), this.standardTags.uri(request), this.standardTags.exception(exception), this.standardTags.status(response), this.standardTags.outcome(response)});
    }

    private Message getResponse(Exchange ex, boolean client) {
        if (client) {
            return Optional.ofNullable(ex.getInMessage()).orElseGet(() -> ((Exchange)ex).getInFaultMessage());
        }
        return Optional.ofNullable(ex.getOutMessage()).orElseGet(() -> ((Exchange)ex).getOutFaultMessage());
    }

    private Message getRequest(Exchange ex, boolean client) {
        if (client) {
            return Optional.ofNullable(ex.getOutMessage()).orElseGet(() -> ((Exchange)ex).getOutFaultMessage());
        }
        return Optional.ofNullable(ex.getInMessage()).orElseGet(() -> ((Exchange)ex).getInFaultMessage());
    }
}

