/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http.optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.CharSequenceInputStream;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.NativeHandlers;
import groovyx.net.http.ToServer;
import groovyx.net.http.TransportingException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class Jackson {
    static final String OBJECT_MAPPER_ID = "0w4XJJnlTNK8dvISuCDTlsusPQE=";

    public static Object parse(ChainedHttpConfig config, FromServer fromServer) {
        try {
            ObjectMapper mapper = (ObjectMapper)config.actualContext(fromServer.getContentType(), OBJECT_MAPPER_ID);
            return mapper.readValue(fromServer.getReader(), config.getChainedResponse().getType());
        }
        catch (IOException e) {
            throw new TransportingException(e);
        }
    }

    public static void encode(ChainedHttpConfig config, ToServer ts) {
        try {
            if (NativeHandlers.Encoders.handleRawUpload(config, ts)) {
                return;
            }
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            ObjectMapper mapper = (ObjectMapper)config.actualContext(request.actualContentType(), OBJECT_MAPPER_ID);
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, request.actualBody());
            ts.toServer(new CharSequenceInputStream(writer.toString(), request.actualCharset()));
        }
        catch (IOException e) {
            throw new TransportingException(e);
        }
    }

    public static void mapper(HttpConfig config, ObjectMapper mapper) {
        Jackson.mapper(config, mapper, ContentTypes.JSON);
    }

    public static void mapper(HttpConfig config, ObjectMapper mapper, Iterable<String> contentTypes) {
        config.context(contentTypes, (Object)OBJECT_MAPPER_ID, (Object)mapper);
    }

    public static void use(HttpConfig config) {
        Jackson.use(config, ContentTypes.JSON);
    }

    public static void use(HttpConfig config, Iterable<String> contentTypes) {
        config.getRequest().encoder(contentTypes, Jackson::encode);
        config.getResponse().parser(contentTypes, Jackson::parse);
    }
}

