/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json.simplifier;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.jolokia.service.serializer.json.simplifier.AttributeExtractor;
import org.jolokia.service.serializer.json.simplifier.SimplifierAccessor;

public class InetAddressSimplifier
extends SimplifierAccessor<InetAddress> {
    public InetAddressSimplifier() {
        super(InetAddress.class);
        this.addExtractor("address", new AddressAttributeExtractor());
    }

    @Override
    public String extractString(Object pValue) {
        InetAddress address = (InetAddress)pValue;
        if (address instanceof Inet4Address) {
            return address.getHostAddress();
        }
        if (address instanceof Inet6Address) {
            String ip6 = address.getHostAddress();
            int percent = ip6.indexOf(37);
            if (percent > 0) {
                return ip6.substring(0, percent);
            }
            return ip6;
        }
        throw new UnsupportedOperationException("InetAddress class not supported:" + address.getClass().getName());
    }

    private class AddressAttributeExtractor
    implements AttributeExtractor<InetAddress> {
        private AddressAttributeExtractor() {
        }

        @Override
        public Object extract(InetAddress address) {
            return InetAddressSimplifier.this.extractString(address);
        }
    }
}

