/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.StringJoiner;
import org.apache.camel.util.FileUtil;

public class MimeTypeHelper {
    public static String sanitizeMimeType(String types) {
        if (types != null) {
            StringJoiner sj = new StringJoiner(",");
            for (String part : types.split(",")) {
                sj.add(part.trim().replace(' ', '+'));
            }
            types = sj.toString();
        }
        return types;
    }

    public static String probeMimeType(String fileName) {
        String answer = null;
        String ext = FileUtil.onlyExt(fileName, true);
        if (ext == null) {
            ext = fileName;
        }
        if (ext != null) {
            answer = MimeTypeHelper.mimeType(ext.toLowerCase());
        }
        return answer;
    }

    private static String mimeType(String ext) {
        return switch (ext) {
            case "123" -> "application/vnd.lotus-1-2-3";
            case "3dml" -> "text/vnd.in3d.3dml";
            case "3ds" -> "image/x-3ds";
            case "3g2" -> "video/3gpp2";
            case "3gp" -> "video/3gpp";
            case "7z" -> "application/x-7z-compressed";
            case "aab" -> "application/x-authorware-bin";
            case "aac" -> "audio/x-aac";
            case "aam" -> "application/x-authorware-map";
            case "aas" -> "application/x-authorware-seg";
            case "abw" -> "application/x-abiword";
            case "ac" -> "application/pkix-attr-cert";
            case "acc" -> "application/vnd.americandynamics.acc";
            case "ace" -> "application/x-ace-compressed";
            case "acu" -> "application/vnd.acucobol";
            case "acutc" -> "application/vnd.acucorp";
            case "adp" -> "audio/adpcm";
            case "aep" -> "application/vnd.audiograph";
            case "afm" -> "application/x-font-type1";
            case "afp" -> "application/vnd.ibm.modcap";
            case "ahead" -> "application/vnd.ahead.space";
            case "ai" -> "application/postscript";
            case "aif" -> "audio/x-aiff";
            case "aifc" -> "audio/x-aiff";
            case "aiff" -> "audio/x-aiff";
            case "air" -> "application/vnd.adobe.air-application-installer-package+zip";
            case "ait" -> "application/vnd.dvb.ait";
            case "ami" -> "application/vnd.amiga.ami";
            case "apk" -> "application/vnd.android.package-archive";
            case "appcache" -> "text/cache-manifest";
            case "application" -> "application/x-ms-application";
            case "apr" -> "application/vnd.lotus-approach";
            case "arc" -> "application/x-freearc";
            case "asc" -> "application/pgp-signature";
            case "asf" -> "video/x-ms-asf";
            case "asm" -> "text/x-asm";
            case "aso" -> "application/vnd.accpac.simply.aso";
            case "asx" -> "video/x-ms-asf";
            case "atc" -> "application/vnd.acucorp";
            case "atom" -> "application/atom+xml";
            case "atomcat" -> "application/atomcat+xml";
            case "atomsvc" -> "application/atomsvc+xml";
            case "atx" -> "application/vnd.antix.game-component";
            case "au" -> "audio/basic";
            case "avi" -> "video/x-msvideo";
            case "avif" -> "image/avif";
            case "aw" -> "application/applixware";
            case "azf" -> "application/vnd.airzip.filesecure.azf";
            case "azs" -> "application/vnd.airzip.filesecure.azs";
            case "azw" -> "application/vnd.amazon.ebook";
            case "bat" -> "application/x-msdownload";
            case "bcpio" -> "application/x-bcpio";
            case "bdf" -> "application/x-font-bdf";
            case "bdm" -> "application/vnd.syncml.dm+wbxml";
            case "bed" -> "application/vnd.realvnc.bed";
            case "bh2" -> "application/vnd.fujitsu.oasysprs";
            case "bin" -> "application/octet-stream";
            case "blb" -> "application/x-blorb";
            case "blorb" -> "application/x-blorb";
            case "bmi" -> "application/vnd.bmi";
            case "bmp" -> "image/bmp";
            case "book" -> "application/vnd.framemaker";
            case "box" -> "application/vnd.previewsystems.box";
            case "boz" -> "application/x-bzip2";
            case "bpk" -> "application/octet-stream";
            case "btif" -> "image/prs.btif";
            case "bz" -> "application/x-bzip";
            case "bz2" -> "application/x-bzip2";
            case "c" -> "text/x-c";
            case "c11amc" -> "application/vnd.cluetrust.cartomobile-config";
            case "c11amz" -> "application/vnd.cluetrust.cartomobile-config-pkg";
            case "c4d" -> "application/vnd.clonk.c4group";
            case "c4f" -> "application/vnd.clonk.c4group";
            case "c4g" -> "application/vnd.clonk.c4group";
            case "c4p" -> "application/vnd.clonk.c4group";
            case "c4u" -> "application/vnd.clonk.c4group";
            case "cab" -> "application/vnd.ms-cab-compressed";
            case "caf" -> "audio/x-caf";
            case "cap" -> "application/vnd.tcpdump.pcap";
            case "car" -> "application/vnd.curl.car";
            case "cat" -> "application/vnd.ms-pki.seccat";
            case "cb7" -> "application/x-cbr";
            case "cba" -> "application/x-cbr";
            case "cbr" -> "application/x-cbr";
            case "cbt" -> "application/x-cbr";
            case "cbz" -> "application/x-cbr";
            case "cc" -> "text/x-c";
            case "cct" -> "application/x-director";
            case "ccxml" -> "application/ccxml+xml";
            case "cdbcmsg" -> "application/vnd.contact.cmsg";
            case "cdf" -> "application/x-netcdf";
            case "cdkey" -> "application/vnd.mediastation.cdkey";
            case "cdmia" -> "application/cdmi-capability";
            case "cdmic" -> "application/cdmi-container";
            case "cdmid" -> "application/cdmi-domain";
            case "cdmio" -> "application/cdmi-object";
            case "cdmiq" -> "application/cdmi-queue";
            case "cdx" -> "chemical/x-cdx";
            case "cdxml" -> "application/vnd.chemdraw+xml";
            case "cdy" -> "application/vnd.cinderella";
            case "cer" -> "application/pkix-cert";
            case "cfs" -> "application/x-cfs-compressed";
            case "cgm" -> "image/cgm";
            case "chat" -> "application/x-chat";
            case "chm" -> "application/vnd.ms-htmlhelp";
            case "chrt" -> "application/vnd.kde.kchart";
            case "cif" -> "chemical/x-cif";
            case "cii" -> "application/vnd.anser-web-certificate-issue-initiation";
            case "cil" -> "application/vnd.ms-artgalry";
            case "cla" -> "application/vnd.claymore";
            case "class" -> "application/java-vm";
            case "clkk" -> "application/vnd.crick.clicker.keyboard";
            case "clkp" -> "application/vnd.crick.clicker.palette";
            case "clkt" -> "application/vnd.crick.clicker.template";
            case "clkw" -> "application/vnd.crick.clicker.wordbank";
            case "clkx" -> "application/vnd.crick.clicker";
            case "clp" -> "application/x-msclip";
            case "cmc" -> "application/vnd.cosmocaller";
            case "cmdf" -> "chemical/x-cmdf";
            case "cml" -> "chemical/x-cml";
            case "cmp" -> "application/vnd.yellowriver-custom-menu";
            case "cmx" -> "image/x-cmx";
            case "cod" -> "application/vnd.rim.cod";
            case "com" -> "application/x-msdownload";
            case "conf" -> "text/plain";
            case "cpio" -> "application/x-cpio";
            case "cpp" -> "text/x-c";
            case "cpt" -> "application/mac-compactpro";
            case "crd" -> "application/x-mscardfile";
            case "crl" -> "application/pkix-crl";
            case "crt" -> "application/x-x509-ca-cert";
            case "cryptonote" -> "application/vnd.rig.cryptonote";
            case "csh" -> "application/x-csh";
            case "csml" -> "chemical/x-csml";
            case "csp" -> "application/vnd.commonspace";
            case "css" -> "text/css";
            case "cst" -> "application/x-director";
            case "csv" -> "text/csv";
            case "cu" -> "application/cu-seeme";
            case "curl" -> "text/vnd.curl";
            case "cww" -> "application/prs.cww";
            case "cxt" -> "application/x-director";
            case "cxx" -> "text/x-c";
            case "dae" -> "model/vnd.collada+xml";
            case "daf" -> "application/vnd.mobius.daf";
            case "dart" -> "application/vnd.dart";
            case "dataless" -> "application/vnd.fdsn.seed";
            case "davmount" -> "application/davmount+xml";
            case "dbk" -> "application/docbook+xml";
            case "dcr" -> "application/x-director";
            case "dcurl" -> "text/vnd.curl.dcurl";
            case "dd2" -> "application/vnd.oma.dd2+xml";
            case "ddd" -> "application/vnd.fujixerox.ddd";
            case "deb" -> "application/x-debian-package";
            case "def" -> "text/plain";
            case "deploy" -> "application/octet-stream";
            case "der" -> "application/x-x509-ca-cert";
            case "dfac" -> "application/vnd.dreamfactory";
            case "dgc" -> "application/x-dgc-compressed";
            case "dic" -> "text/x-c";
            case "dir" -> "application/x-director";
            case "dis" -> "application/vnd.mobius.dis";
            case "dist" -> "application/octet-stream";
            case "distz" -> "application/octet-stream";
            case "djv" -> "image/vnd.djvu";
            case "djvu" -> "image/vnd.djvu";
            case "dll" -> "application/x-msdownload";
            case "dmg" -> "application/x-apple-diskimage";
            case "dmp" -> "application/vnd.tcpdump.pcap";
            case "dms" -> "application/octet-stream";
            case "dna" -> "application/vnd.dna";
            case "doc" -> "application/msword";
            case "docm" -> "application/vnd.ms-word.document.macroenabled.12";
            case "docx" -> "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            case "dot" -> "application/msword";
            case "dotm" -> "application/vnd.ms-word.template.macroenabled.12";
            case "dotx" -> "application/vnd.openxmlformats-officedocument.wordprocessingml.template";
            case "dp" -> "application/vnd.osgi.dp";
            case "dpg" -> "application/vnd.dpgraph";
            case "dra" -> "audio/vnd.dra";
            case "dsc" -> "text/prs.lines.tag";
            case "dssc" -> "application/dssc+der";
            case "dtb" -> "application/x-dtbook+xml";
            case "dtd" -> "application/xml-dtd";
            case "dts" -> "audio/vnd.dts";
            case "dtshd" -> "audio/vnd.dts.hd";
            case "dump" -> "application/octet-stream";
            case "dvb" -> "video/vnd.dvb.file";
            case "dvi" -> "application/x-dvi";
            case "dwf" -> "model/vnd.dwf";
            case "dwg" -> "image/vnd.dwg";
            case "dxf" -> "image/vnd.dxf";
            case "dxp" -> "application/vnd.spotfire.dxp";
            case "dxr" -> "application/x-director";
            case "ecelp4800" -> "audio/vnd.nuera.ecelp4800";
            case "ecelp7470" -> "audio/vnd.nuera.ecelp7470";
            case "ecelp9600" -> "audio/vnd.nuera.ecelp9600";
            case "ecma" -> "application/ecmascript";
            case "edm" -> "application/vnd.novadigm.edm";
            case "edx" -> "application/vnd.novadigm.edx";
            case "efif" -> "application/vnd.picsel";
            case "ei6" -> "application/vnd.pg.osasli";
            case "elc" -> "application/octet-stream";
            case "emf" -> "application/x-msmetafile";
            case "eml" -> "message/rfc822";
            case "emma" -> "application/emma+xml";
            case "emz" -> "application/x-msmetafile";
            case "eol" -> "audio/vnd.digital-winds";
            case "eot" -> "application/vnd.ms-fontobject";
            case "eps" -> "application/postscript";
            case "epub" -> "application/epub+zip";
            case "es3" -> "application/vnd.eszigno3+xml";
            case "esa" -> "application/vnd.osgi.subsystem";
            case "esf" -> "application/vnd.epson.esf";
            case "et3" -> "application/vnd.eszigno3+xml";
            case "etx" -> "text/x-setext";
            case "eva" -> "application/x-eva";
            case "evy" -> "application/x-envoy";
            case "exe" -> "application/x-msdownload";
            case "exi" -> "application/exi";
            case "ext" -> "application/vnd.novadigm.ext";
            case "ez" -> "application/andrew-inset";
            case "ez2" -> "application/vnd.ezpix-album";
            case "ez3" -> "application/vnd.ezpix-package";
            case "f" -> "text/x-fortran";
            case "f4v" -> "video/x-f4v";
            case "f77" -> "text/x-fortran";
            case "f90" -> "text/x-fortran";
            case "fbs" -> "image/vnd.fastbidsheet";
            case "fcdt" -> "application/vnd.adobe.formscentral.fcdt";
            case "fcs" -> "application/vnd.isac.fcs";
            case "fdf" -> "application/vnd.fdf";
            case "fe_launch" -> "application/vnd.denovo.fcselayout-link";
            case "fg5" -> "application/vnd.fujitsu.oasysgp";
            case "fgd" -> "application/x-director";
            case "fh" -> "image/x-freehand";
            case "fh4" -> "image/x-freehand";
            case "fh5" -> "image/x-freehand";
            case "fh7" -> "image/x-freehand";
            case "fhc" -> "image/x-freehand";
            case "fig" -> "application/x-xfig";
            case "flac" -> "audio/x-flac";
            case "fli" -> "video/x-fli";
            case "flo" -> "application/vnd.micrografx.flo";
            case "flv" -> "video/x-flv";
            case "flw" -> "application/vnd.kde.kivio";
            case "flx" -> "text/vnd.fmi.flexstor";
            case "fly" -> "text/vnd.fly";
            case "fm" -> "application/vnd.framemaker";
            case "fnc" -> "application/vnd.frogans.fnc";
            case "for" -> "text/x-fortran";
            case "fpx" -> "image/vnd.fpx";
            case "frame" -> "application/vnd.framemaker";
            case "fsc" -> "application/vnd.fsc.weblaunch";
            case "fst" -> "image/vnd.fst";
            case "ftc" -> "application/vnd.fluxtime.clip";
            case "fti" -> "application/vnd.anser-web-funds-transfer-initiation";
            case "fvt" -> "video/vnd.fvt";
            case "fxp" -> "application/vnd.adobe.fxp";
            case "fxpl" -> "application/vnd.adobe.fxp";
            case "fzs" -> "application/vnd.fuzzysheet";
            case "g2w" -> "application/vnd.geoplan";
            case "g3" -> "image/g3fax";
            case "g3w" -> "application/vnd.geospace";
            case "gac" -> "application/vnd.groove-account";
            case "gam" -> "application/x-tads";
            case "gbr" -> "application/rpki-ghostbusters";
            case "gca" -> "application/x-gca-compressed";
            case "gdl" -> "model/vnd.gdl";
            case "geo" -> "application/vnd.dynageo";
            case "gex" -> "application/vnd.geometry-explorer";
            case "ggb" -> "application/vnd.geogebra.file";
            case "ggs" -> "application/vnd.geogebra.slides";
            case "ggt" -> "application/vnd.geogebra.tool";
            case "ghf" -> "application/vnd.groove-help";
            case "gif" -> "image/gif";
            case "gim" -> "application/vnd.groove-identity-message";
            case "gml" -> "application/gml+xml";
            case "gmx" -> "application/vnd.gmx";
            case "gnumeric" -> "application/x-gnumeric";
            case "gph" -> "application/vnd.flographit";
            case "gpx" -> "application/gpx+xml";
            case "gqf" -> "application/vnd.grafeq";
            case "gqs" -> "application/vnd.grafeq";
            case "gram" -> "application/srgs";
            case "gramps" -> "application/x-gramps-xml";
            case "gre" -> "application/vnd.geometry-explorer";
            case "grv" -> "application/vnd.groove-injector";
            case "grxml" -> "application/srgs+xml";
            case "gsf" -> "application/x-font-ghostscript";
            case "gtar" -> "application/x-gtar";
            case "gtm" -> "application/vnd.groove-tool-message";
            case "gtw" -> "model/vnd.gtw";
            case "gv" -> "text/vnd.graphviz";
            case "gxf" -> "application/gxf";
            case "gxt" -> "application/vnd.geonext";
            case "h" -> "text/x-c";
            case "h261" -> "video/h261";
            case "h263" -> "video/h263";
            case "h264" -> "video/h264";
            case "hal" -> "application/vnd.hal+xml";
            case "hbci" -> "application/vnd.hbci";
            case "hdf" -> "application/x-hdf";
            case "hh" -> "text/x-c";
            case "hlp" -> "application/winhlp";
            case "hpgl" -> "application/vnd.hp-hpgl";
            case "hpid" -> "application/vnd.hp-hpid";
            case "hps" -> "application/vnd.hp-hps";
            case "hqx" -> "application/mac-binhex40";
            case "htke" -> "application/vnd.kenameaapp";
            case "htm" -> "text/html";
            case "html" -> "text/html";
            case "hvd" -> "application/vnd.yamaha.hv-dic";
            case "hvp" -> "application/vnd.yamaha.hv-voice";
            case "hvs" -> "application/vnd.yamaha.hv-script";
            case "i2g" -> "application/vnd.intergeo";
            case "icc" -> "application/vnd.iccprofile";
            case "ice" -> "x-conference/x-cooltalk";
            case "icm" -> "application/vnd.iccprofile";
            case "ico" -> "image/x-icon";
            case "ics" -> "text/calendar";
            case "ief" -> "image/ief";
            case "ifb" -> "text/calendar";
            case "ifm" -> "application/vnd.shana.informed.formdata";
            case "iges" -> "model/iges";
            case "igl" -> "application/vnd.igloader";
            case "igm" -> "application/vnd.insors.igm";
            case "igs" -> "model/iges";
            case "igx" -> "application/vnd.micrografx.igx";
            case "iif" -> "application/vnd.shana.informed.interchange";
            case "imp" -> "application/vnd.accpac.simply.imp";
            case "ims" -> "application/vnd.ms-ims";
            case "in" -> "text/plain";
            case "ink" -> "application/inkml+xml";
            case "inkml" -> "application/inkml+xml";
            case "install" -> "application/x-install-instructions";
            case "iota" -> "application/vnd.astraea-software.iota";
            case "ipfix" -> "application/ipfix";
            case "ipk" -> "application/vnd.shana.informed.package";
            case "irm" -> "application/vnd.ibm.rights-management";
            case "irp" -> "application/vnd.irepository.package+xml";
            case "iso" -> "application/x-iso9660-image";
            case "itp" -> "application/vnd.shana.informed.formtemplate";
            case "ivp" -> "application/vnd.immervision-ivp";
            case "ivu" -> "application/vnd.immervision-ivu";
            case "jad" -> "text/vnd.sun.j2me.app-descriptor";
            case "jam" -> "application/vnd.jam";
            case "jar" -> "application/java-archive";
            case "java" -> "text/x-java-source";
            case "jisp" -> "application/vnd.jisp";
            case "jlt" -> "application/vnd.hp-jlyt";
            case "jnlp" -> "application/x-java-jnlp-file";
            case "joda" -> "application/vnd.joost.joda-archive";
            case "jpe" -> "image/jpeg";
            case "jpeg" -> "image/jpeg";
            case "jpg" -> "image/jpeg";
            case "jpgm" -> "video/jpm";
            case "jpgv" -> "video/jpeg";
            case "jpm" -> "video/jpm";
            case "js" -> "text/javascript";
            case "json" -> "application/json";
            case "jsonml" -> "application/jsonml+json";
            case "jxl" -> "image/jxl";
            case "kar" -> "audio/midi";
            case "karbon" -> "application/vnd.kde.karbon";
            case "kfo" -> "application/vnd.kde.kformula";
            case "kia" -> "application/vnd.kidspiration";
            case "kml" -> "application/vnd.google-earth.kml+xml";
            case "kmz" -> "application/vnd.google-earth.kmz";
            case "kne" -> "application/vnd.kinar";
            case "knp" -> "application/vnd.kinar";
            case "kon" -> "application/vnd.kde.kontour";
            case "kpr" -> "application/vnd.kde.kpresenter";
            case "kpt" -> "application/vnd.kde.kpresenter";
            case "kpxx" -> "application/vnd.ds-keypoint";
            case "ksp" -> "application/vnd.kde.kspread";
            case "ktr" -> "application/vnd.kahootz";
            case "ktx" -> "image/ktx";
            case "ktz" -> "application/vnd.kahootz";
            case "kwd" -> "application/vnd.kde.kword";
            case "kwt" -> "application/vnd.kde.kword";
            case "lasxml" -> "application/vnd.las.las+xml";
            case "latex" -> "application/x-latex";
            case "lbd" -> "application/vnd.llamagraphics.life-balance.desktop";
            case "lbe" -> "application/vnd.llamagraphics.life-balance.exchange+xml";
            case "les" -> "application/vnd.hhe.lesson-player";
            case "lha" -> "application/x-lzh-compressed";
            case "link66" -> "application/vnd.route66.link66+xml";
            case "list" -> "text/plain";
            case "list3820" -> "application/vnd.ibm.modcap";
            case "listafp" -> "application/vnd.ibm.modcap";
            case "lnk" -> "application/x-ms-shortcut";
            case "log" -> "text/plain";
            case "lostxml" -> "application/lost+xml";
            case "lrf" -> "application/octet-stream";
            case "lrm" -> "application/vnd.ms-lrm";
            case "ltf" -> "application/vnd.frogans.ltf";
            case "lvp" -> "audio/vnd.lucent.voice";
            case "lwp" -> "application/vnd.lotus-wordpro";
            case "lzh" -> "application/x-lzh-compressed";
            case "m13" -> "application/x-msmediaview";
            case "m14" -> "application/x-msmediaview";
            case "m1v" -> "video/mpeg";
            case "m21" -> "application/mp21";
            case "m2a" -> "audio/mpeg";
            case "m2t" -> "video/mp2t";
            case "m2ts" -> "video/mp2t";
            case "m2v" -> "video/mpeg";
            case "m3a" -> "audio/mpeg";
            case "m3u" -> "audio/x-mpegurl";
            case "m3u8" -> "application/vnd.apple.mpegurl";
            case "m4a" -> "audio/mp4";
            case "m4u" -> "video/vnd.mpegurl";
            case "m4v" -> "video/x-m4v";
            case "ma" -> "application/mathematica";
            case "mads" -> "application/mads+xml";
            case "mag" -> "application/vnd.ecowin.chart";
            case "maker" -> "application/vnd.framemaker";
            case "man" -> "text/troff";
            case "mar" -> "application/octet-stream";
            case "mathml" -> "application/mathml+xml";
            case "mb" -> "application/mathematica";
            case "mbk" -> "application/vnd.mobius.mbk";
            case "mbox" -> "application/mbox";
            case "mc1" -> "application/vnd.medcalcdata";
            case "mcd" -> "application/vnd.mcd";
            case "mcurl" -> "text/vnd.curl.mcurl";
            case "mdb" -> "application/x-msaccess";
            case "mdi" -> "image/vnd.ms-modi";
            case "me" -> "text/troff";
            case "mesh" -> "model/mesh";
            case "meta4" -> "application/metalink4+xml";
            case "metalink" -> "application/metalink+xml";
            case "mets" -> "application/mets+xml";
            case "mfm" -> "application/vnd.mfmp";
            case "mft" -> "application/rpki-manifest";
            case "mgp" -> "application/vnd.osgeo.mapguide.package";
            case "mgz" -> "application/vnd.proteus.magazine";
            case "mid" -> "audio/midi";
            case "midi" -> "audio/midi";
            case "mie" -> "application/x-mie";
            case "mif" -> "application/vnd.mif";
            case "mime" -> "message/rfc822";
            case "mj2" -> "video/mj2";
            case "mjp2" -> "video/mj2";
            case "mjs" -> "text/javascript";
            case "mk3d" -> "video/x-matroska";
            case "mka" -> "audio/x-matroska";
            case "mks" -> "video/x-matroska";
            case "mkv" -> "video/x-matroska";
            case "mlp" -> "application/vnd.dolby.mlp";
            case "mmd" -> "application/vnd.chipnuts.karaoke-mmd";
            case "mmf" -> "application/vnd.smaf";
            case "mmr" -> "image/vnd.fujixerox.edmics-mmr";
            case "mng" -> "video/x-mng";
            case "mny" -> "application/x-msmoney";
            case "mobi" -> "application/x-mobipocket-ebook";
            case "mods" -> "application/mods+xml";
            case "mov" -> "video/quicktime";
            case "movie" -> "video/x-sgi-movie";
            case "mp2" -> "audio/mpeg";
            case "mp21" -> "application/mp21";
            case "mp2a" -> "audio/mpeg";
            case "mp3" -> "audio/mpeg";
            case "mp4" -> "video/mp4";
            case "mp4a" -> "audio/mp4";
            case "mp4s" -> "application/mp4";
            case "mp4v" -> "video/mp4";
            case "mpc" -> "application/vnd.mophun.certificate";
            case "mpe" -> "video/mpeg";
            case "mpeg" -> "video/mpeg";
            case "mpg" -> "video/mpeg";
            case "mpg4" -> "video/mp4";
            case "mpga" -> "audio/mpeg";
            case "mpkg" -> "application/vnd.apple.installer+xml";
            case "mpm" -> "application/vnd.blueice.multipass";
            case "mpn" -> "application/vnd.mophun.application";
            case "mpp" -> "application/vnd.ms-project";
            case "mpt" -> "application/vnd.ms-project";
            case "mpy" -> "application/vnd.ibm.minipay";
            case "mqy" -> "application/vnd.mobius.mqy";
            case "mrc" -> "application/marc";
            case "mrcx" -> "application/marcxml+xml";
            case "ms" -> "text/troff";
            case "mscml" -> "application/mediaservercontrol+xml";
            case "mseed" -> "application/vnd.fdsn.mseed";
            case "mseq" -> "application/vnd.mseq";
            case "msf" -> "application/vnd.epson.msf";
            case "msh" -> "model/mesh";
            case "msi" -> "application/x-msdownload";
            case "msl" -> "application/vnd.mobius.msl";
            case "msty" -> "application/vnd.muvee.style";
            case "mts" -> "video/mp2t";
            case "mus" -> "application/vnd.musician";
            case "musicxml" -> "application/vnd.recordare.musicxml+xml";
            case "mvb" -> "application/x-msmediaview";
            case "mwf" -> "application/vnd.mfer";
            case "mxf" -> "application/mxf";
            case "mxl" -> "application/vnd.recordare.musicxml";
            case "mxml" -> "application/xv+xml";
            case "mxs" -> "application/vnd.triscape.mxs";
            case "mxu" -> "video/vnd.mpegurl";
            case "n-gage" -> "application/vnd.nokia.n-gage.symbian.install";
            case "n3" -> "text/n3";
            case "nb" -> "application/mathematica";
            case "nbp" -> "application/vnd.wolfram.player";
            case "nc" -> "application/x-netcdf";
            case "ncx" -> "application/x-dtbncx+xml";
            case "nfo" -> "text/x-nfo";
            case "ngdat" -> "application/vnd.nokia.n-gage.data";
            case "nitf" -> "application/vnd.nitf";
            case "nlu" -> "application/vnd.neurolanguage.nlu";
            case "nml" -> "application/vnd.enliven";
            case "nnd" -> "application/vnd.noblenet-directory";
            case "nns" -> "application/vnd.noblenet-sealer";
            case "nnw" -> "application/vnd.noblenet-web";
            case "npx" -> "image/vnd.net-fpx";
            case "nsc" -> "application/x-conference";
            case "nsf" -> "application/vnd.lotus-notes";
            case "ntf" -> "application/vnd.nitf";
            case "nzb" -> "application/x-nzb";
            case "oa2" -> "application/vnd.fujitsu.oasys2";
            case "oa3" -> "application/vnd.fujitsu.oasys3";
            case "oas" -> "application/vnd.fujitsu.oasys";
            case "obd" -> "application/x-msbinder";
            case "obj" -> "application/x-tgif";
            case "oda" -> "application/oda";
            case "odb" -> "application/vnd.oasis.opendocument.database";
            case "odc" -> "application/vnd.oasis.opendocument.chart";
            case "odf" -> "application/vnd.oasis.opendocument.formula";
            case "odft" -> "application/vnd.oasis.opendocument.formula-template";
            case "odg" -> "application/vnd.oasis.opendocument.graphics";
            case "odi" -> "application/vnd.oasis.opendocument.image";
            case "odm" -> "application/vnd.oasis.opendocument.text-master";
            case "odp" -> "application/vnd.oasis.opendocument.presentation";
            case "ods" -> "application/vnd.oasis.opendocument.spreadsheet";
            case "odt" -> "application/vnd.oasis.opendocument.text";
            case "oga" -> "audio/ogg";
            case "ogg" -> "audio/ogg";
            case "ogv" -> "video/ogg";
            case "ogx" -> "application/ogg";
            case "omdoc" -> "application/omdoc+xml";
            case "onepkg" -> "application/onenote";
            case "onetmp" -> "application/onenote";
            case "onetoc" -> "application/onenote";
            case "onetoc2" -> "application/onenote";
            case "opf" -> "application/oebps-package+xml";
            case "opml" -> "text/x-opml";
            case "oprc" -> "application/vnd.palm";
            case "opus" -> "audio/ogg";
            case "org" -> "application/vnd.lotus-organizer";
            case "osf" -> "application/vnd.yamaha.openscoreformat";
            case "osfpvg" -> "application/vnd.yamaha.openscoreformat.osfpvg+xml";
            case "otc" -> "application/vnd.oasis.opendocument.chart-template";
            case "otf" -> "font/otf";
            case "otg" -> "application/vnd.oasis.opendocument.graphics-template";
            case "oth" -> "application/vnd.oasis.opendocument.text-web";
            case "oti" -> "application/vnd.oasis.opendocument.image-template";
            case "otp" -> "application/vnd.oasis.opendocument.presentation-template";
            case "ots" -> "application/vnd.oasis.opendocument.spreadsheet-template";
            case "ott" -> "application/vnd.oasis.opendocument.text-template";
            case "oxps" -> "application/oxps";
            case "oxt" -> "application/vnd.openofficeorg.extension";
            case "p" -> "text/x-pascal";
            case "p10" -> "application/pkcs10";
            case "p12" -> "application/x-pkcs12";
            case "p7b" -> "application/x-pkcs7-certificates";
            case "p7c" -> "application/pkcs7-mime";
            case "p7m" -> "application/pkcs7-mime";
            case "p7r" -> "application/x-pkcs7-certreqresp";
            case "p7s" -> "application/pkcs7-signature";
            case "p8" -> "application/pkcs8";
            case "pas" -> "text/x-pascal";
            case "paw" -> "application/vnd.pawaafile";
            case "pbd" -> "application/vnd.powerbuilder6";
            case "pbm" -> "image/x-portable-bitmap";
            case "pcap" -> "application/vnd.tcpdump.pcap";
            case "pcf" -> "application/x-font-pcf";
            case "pcl" -> "application/vnd.hp-pcl";
            case "pclxl" -> "application/vnd.hp-pclxl";
            case "pct" -> "image/x-pict";
            case "pcurl" -> "application/vnd.curl.pcurl";
            case "pcx" -> "image/x-pcx";
            case "pdb" -> "application/vnd.palm";
            case "pdf" -> "application/pdf";
            case "pfa" -> "application/x-font-type1";
            case "pfb" -> "application/x-font-type1";
            case "pfm" -> "application/x-font-type1";
            case "pfr" -> "application/font-tdpfr";
            case "pfx" -> "application/x-pkcs12";
            case "pgm" -> "image/x-portable-graymap";
            case "pgn" -> "application/x-chess-pgn";
            case "pgp" -> "application/pgp-encrypted";
            case "pic" -> "image/x-pict";
            case "pkg" -> "application/octet-stream";
            case "pki" -> "application/pkixcmp";
            case "pkipath" -> "application/pkix-pkipath";
            case "plb" -> "application/vnd.3gpp.pic-bw-large";
            case "plc" -> "application/vnd.mobius.plc";
            case "plf" -> "application/vnd.pocketlearn";
            case "pls" -> "application/pls+xml";
            case "pml" -> "application/vnd.ctc-posml";
            case "png" -> "image/png";
            case "pnm" -> "image/x-portable-anymap";
            case "portpkg" -> "application/vnd.macports.portpkg";
            case "pot" -> "application/vnd.ms-powerpoint";
            case "potm" -> "application/vnd.ms-powerpoint.template.macroenabled.12";
            case "potx" -> "application/vnd.openxmlformats-officedocument.presentationml.template";
            case "ppam" -> "application/vnd.ms-powerpoint.addin.macroenabled.12";
            case "ppd" -> "application/vnd.cups-ppd";
            case "ppm" -> "image/x-portable-pixmap";
            case "pps" -> "application/vnd.ms-powerpoint";
            case "ppsm" -> "application/vnd.ms-powerpoint.slideshow.macroenabled.12";
            case "ppsx" -> "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
            case "ppt" -> "application/vnd.ms-powerpoint";
            case "pptm" -> "application/vnd.ms-powerpoint.presentation.macroenabled.12";
            case "pptx" -> "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            case "pqa" -> "application/vnd.palm";
            case "prc" -> "application/x-mobipocket-ebook";
            case "pre" -> "application/vnd.lotus-freelance";
            case "prf" -> "application/pics-rules";
            case "ps" -> "application/postscript";
            case "psb" -> "application/vnd.3gpp.pic-bw-small";
            case "psd" -> "image/vnd.adobe.photoshop";
            case "psf" -> "application/x-font-linux-psf";
            case "pskcxml" -> "application/pskc+xml";
            case "ptid" -> "application/vnd.pvi.ptid1";
            case "pub" -> "application/x-mspublisher";
            case "pvb" -> "application/vnd.3gpp.pic-bw-var";
            case "pwn" -> "application/vnd.3m.post-it-notes";
            case "pya" -> "audio/vnd.ms-playready.media.pya";
            case "pyv" -> "video/vnd.ms-playready.media.pyv";
            case "qam" -> "application/vnd.epson.quickanime";
            case "qbo" -> "application/vnd.intu.qbo";
            case "qfx" -> "application/vnd.intu.qfx";
            case "qps" -> "application/vnd.publishare-delta-tree";
            case "qt" -> "video/quicktime";
            case "qwd" -> "application/vnd.quark.quarkxpress";
            case "qwt" -> "application/vnd.quark.quarkxpress";
            case "qxb" -> "application/vnd.quark.quarkxpress";
            case "qxd" -> "application/vnd.quark.quarkxpress";
            case "qxl" -> "application/vnd.quark.quarkxpress";
            case "qxt" -> "application/vnd.quark.quarkxpress";
            case "ra" -> "audio/x-pn-realaudio";
            case "ram" -> "audio/x-pn-realaudio";
            case "rar" -> "application/x-rar-compressed";
            case "ras" -> "image/x-cmu-raster";
            case "rcprofile" -> "application/vnd.ipunplugged.rcprofile";
            case "rdf" -> "application/rdf+xml";
            case "rdz" -> "application/vnd.data-vision.rdz";
            case "rep" -> "application/vnd.businessobjects";
            case "res" -> "application/x-dtbresource+xml";
            case "rgb" -> "image/x-rgb";
            case "rif" -> "application/reginfo+xml";
            case "rip" -> "audio/vnd.rip";
            case "ris" -> "application/x-research-info-systems";
            case "rl" -> "application/resource-lists+xml";
            case "rlc" -> "image/vnd.fujixerox.edmics-rlc";
            case "rld" -> "application/resource-lists-diff+xml";
            case "rm" -> "application/vnd.rn-realmedia";
            case "rmi" -> "audio/midi";
            case "rmp" -> "audio/x-pn-realaudio-plugin";
            case "rms" -> "application/vnd.jcp.javame.midlet-rms";
            case "rmvb" -> "application/vnd.rn-realmedia-vbr";
            case "rnc" -> "application/relax-ng-compact-syntax";
            case "roa" -> "application/rpki-roa";
            case "roff" -> "text/troff";
            case "rp9" -> "application/vnd.cloanto.rp9";
            case "rpss" -> "application/vnd.nokia.radio-presets";
            case "rpst" -> "application/vnd.nokia.radio-preset";
            case "rq" -> "application/sparql-query";
            case "rs" -> "application/rls-services+xml";
            case "rsd" -> "application/rsd+xml";
            case "rss" -> "application/rss+xml";
            case "rtf" -> "application/rtf";
            case "rtx" -> "text/richtext";
            case "s" -> "text/x-asm";
            case "s3m" -> "audio/s3m";
            case "saf" -> "application/vnd.yamaha.smaf-audio";
            case "sbml" -> "application/sbml+xml";
            case "sc" -> "application/vnd.ibm.secure-container";
            case "scd" -> "application/x-msschedule";
            case "scm" -> "application/vnd.lotus-screencam";
            case "scq" -> "application/scvp-cv-request";
            case "scs" -> "application/scvp-cv-response";
            case "scurl" -> "text/vnd.curl.scurl";
            case "sda" -> "application/vnd.stardivision.draw";
            case "sdc" -> "application/vnd.stardivision.calc";
            case "sdd" -> "application/vnd.stardivision.impress";
            case "sdkd" -> "application/vnd.solent.sdkm+xml";
            case "sdkm" -> "application/vnd.solent.sdkm+xml";
            case "sdp" -> "application/sdp";
            case "sdw" -> "application/vnd.stardivision.writer";
            case "see" -> "application/vnd.seemail";
            case "seed" -> "application/vnd.fdsn.seed";
            case "sema" -> "application/vnd.sema";
            case "semd" -> "application/vnd.semd";
            case "semf" -> "application/vnd.semf";
            case "ser" -> "application/java-serialized-object";
            case "setpay" -> "application/set-payment-initiation";
            case "setreg" -> "application/set-registration-initiation";
            case "sfd-hdstx" -> "application/vnd.hydrostatix.sof-data";
            case "sfs" -> "application/vnd.spotfire.sfs";
            case "sfv" -> "text/x-sfv";
            case "sgi" -> "image/sgi";
            case "sgl" -> "application/vnd.stardivision.writer-global";
            case "sgm" -> "text/sgml";
            case "sgml" -> "text/sgml";
            case "sh" -> "application/x-sh";
            case "shar" -> "application/x-shar";
            case "shf" -> "application/shf+xml";
            case "sid" -> "image/x-mrsid-image";
            case "sig" -> "application/pgp-signature";
            case "sil" -> "audio/silk";
            case "silo" -> "model/mesh";
            case "sis" -> "application/vnd.symbian.install";
            case "sisx" -> "application/vnd.symbian.install";
            case "sit" -> "application/x-stuffit";
            case "sitx" -> "application/x-stuffitx";
            case "skd" -> "application/vnd.koan";
            case "skm" -> "application/vnd.koan";
            case "skp" -> "application/vnd.koan";
            case "skt" -> "application/vnd.koan";
            case "sldm" -> "application/vnd.ms-powerpoint.slide.macroenabled.12";
            case "sldx" -> "application/vnd.openxmlformats-officedocument.presentationml.slide";
            case "slt" -> "application/vnd.epson.salt";
            case "sm" -> "application/vnd.stepmania.stepchart";
            case "smf" -> "application/vnd.stardivision.math";
            case "smi" -> "application/smil+xml";
            case "smil" -> "application/smil+xml";
            case "smv" -> "video/x-smv";
            case "smzip" -> "application/vnd.stepmania.package";
            case "snd" -> "audio/basic";
            case "snf" -> "application/x-font-snf";
            case "so" -> "application/octet-stream";
            case "spc" -> "application/x-pkcs7-certificates";
            case "spf" -> "application/vnd.yamaha.smaf-phrase";
            case "spl" -> "application/x-futuresplash";
            case "spot" -> "text/vnd.in3d.spot";
            case "spp" -> "application/scvp-vp-response";
            case "spq" -> "application/scvp-vp-request";
            case "spx" -> "audio/ogg";
            case "sql" -> "application/x-sql";
            case "src" -> "application/x-wais-source";
            case "srt" -> "application/x-subrip";
            case "sru" -> "application/sru+xml";
            case "srx" -> "application/sparql-results+xml";
            case "ssdl" -> "application/ssdl+xml";
            case "sse" -> "application/vnd.kodak-descriptor";
            case "ssf" -> "application/vnd.epson.ssf";
            case "ssml" -> "application/ssml+xml";
            case "st" -> "application/vnd.sailingtracker.track";
            case "stc" -> "application/vnd.sun.xml.calc.template";
            case "std" -> "application/vnd.sun.xml.draw.template";
            case "stf" -> "application/vnd.wt.stf";
            case "sti" -> "application/vnd.sun.xml.impress.template";
            case "stk" -> "application/hyperstudio";
            case "stl" -> "application/vnd.ms-pki.stl";
            case "str" -> "application/vnd.pg.format";
            case "stw" -> "application/vnd.sun.xml.writer.template";
            case "sub" -> "text/vnd.dvb.subtitle";
            case "sus" -> "application/vnd.sus-calendar";
            case "susp" -> "application/vnd.sus-calendar";
            case "sv4cpio" -> "application/x-sv4cpio";
            case "sv4crc" -> "application/x-sv4crc";
            case "svc" -> "application/vnd.dvb.service";
            case "svd" -> "application/vnd.svd";
            case "svg" -> "image/svg+xml";
            case "svgz" -> "image/svg+xml";
            case "swa" -> "application/x-director";
            case "swf" -> "application/x-shockwave-flash";
            case "swi" -> "application/vnd.aristanetworks.swi";
            case "sxc" -> "application/vnd.sun.xml.calc";
            case "sxd" -> "application/vnd.sun.xml.draw";
            case "sxg" -> "application/vnd.sun.xml.writer.global";
            case "sxi" -> "application/vnd.sun.xml.impress";
            case "sxm" -> "application/vnd.sun.xml.math";
            case "sxw" -> "application/vnd.sun.xml.writer";
            case "t" -> "text/troff";
            case "t3" -> "application/x-t3vm-image";
            case "taglet" -> "application/vnd.mynfc";
            case "tao" -> "application/vnd.tao.intent-module-archive";
            case "tar" -> "application/x-tar";
            case "tcap" -> "application/vnd.3gpp2.tcap";
            case "tcl" -> "application/x-tcl";
            case "teacher" -> "application/vnd.smart.teacher";
            case "tei" -> "application/tei+xml";
            case "teicorpus" -> "application/tei+xml";
            case "tex" -> "application/x-tex";
            case "texi" -> "application/x-texinfo";
            case "texinfo" -> "application/x-texinfo";
            case "text" -> "text/plain";
            case "tfi" -> "application/thraud+xml";
            case "tfm" -> "application/x-tex-tfm";
            case "tga" -> "image/x-tga";
            case "thmx" -> "application/vnd.ms-officetheme";
            case "tif" -> "image/tiff";
            case "tiff" -> "image/tiff";
            case "tmo" -> "application/vnd.tmobile-livetv";
            case "torrent" -> "application/x-bittorrent";
            case "tpl" -> "application/vnd.groove-tool-template";
            case "tpt" -> "application/vnd.trid.tpt";
            case "tr" -> "text/troff";
            case "tra" -> "application/vnd.trueapp";
            case "trm" -> "application/x-msterminal";
            case "ts" -> "video/mp2t";
            case "tsd" -> "application/timestamped-data";
            case "tsv" -> "text/tab-separated-values";
            case "ttc" -> "font/collection";
            case "ttf" -> "font/ttf";
            case "ttl" -> "text/turtle";
            case "twd" -> "application/vnd.simtech-mindmapper";
            case "twds" -> "application/vnd.simtech-mindmapper";
            case "txd" -> "application/vnd.genomatix.tuxedo";
            case "txf" -> "application/vnd.mobius.txf";
            case "txt" -> "text/plain";
            case "u32" -> "application/x-authorware-bin";
            case "udeb" -> "application/x-debian-package";
            case "ufd" -> "application/vnd.ufdl";
            case "ufdl" -> "application/vnd.ufdl";
            case "ulx" -> "application/x-glulx";
            case "umj" -> "application/vnd.umajin";
            case "unityweb" -> "application/vnd.unity";
            case "uoml" -> "application/vnd.uoml+xml";
            case "uri" -> "text/uri-list";
            case "uris" -> "text/uri-list";
            case "urls" -> "text/uri-list";
            case "ustar" -> "application/x-ustar";
            case "utz" -> "application/vnd.uiq.theme";
            case "uu" -> "text/x-uuencode";
            case "uva" -> "audio/vnd.dece.audio";
            case "uvd" -> "application/vnd.dece.data";
            case "uvf" -> "application/vnd.dece.data";
            case "uvg" -> "image/vnd.dece.graphic";
            case "uvh" -> "video/vnd.dece.hd";
            case "uvi" -> "image/vnd.dece.graphic";
            case "uvm" -> "video/vnd.dece.mobile";
            case "uvp" -> "video/vnd.dece.pd";
            case "uvs" -> "video/vnd.dece.sd";
            case "uvt" -> "application/vnd.dece.ttml+xml";
            case "uvu" -> "video/vnd.uvvu.mp4";
            case "uvv" -> "video/vnd.dece.video";
            case "uvva" -> "audio/vnd.dece.audio";
            case "uvvd" -> "application/vnd.dece.data";
            case "uvvf" -> "application/vnd.dece.data";
            case "uvvg" -> "image/vnd.dece.graphic";
            case "uvvh" -> "video/vnd.dece.hd";
            case "uvvi" -> "image/vnd.dece.graphic";
            case "uvvm" -> "video/vnd.dece.mobile";
            case "uvvp" -> "video/vnd.dece.pd";
            case "uvvs" -> "video/vnd.dece.sd";
            case "uvvt" -> "application/vnd.dece.ttml+xml";
            case "uvvu" -> "video/vnd.uvvu.mp4";
            case "uvvv" -> "video/vnd.dece.video";
            case "uvvx" -> "application/vnd.dece.unspecified";
            case "uvvz" -> "application/vnd.dece.zip";
            case "uvx" -> "application/vnd.dece.unspecified";
            case "uvz" -> "application/vnd.dece.zip";
            case "vcard" -> "text/vcard";
            case "vcd" -> "application/x-cdlink";
            case "vcf" -> "text/x-vcard";
            case "vcg" -> "application/vnd.groove-vcard";
            case "vcs" -> "text/x-vcalendar";
            case "vcx" -> "application/vnd.vcx";
            case "vis" -> "application/vnd.visionary";
            case "viv" -> "video/vnd.vivo";
            case "vob" -> "video/x-ms-vob";
            case "vor" -> "application/vnd.stardivision.writer";
            case "vox" -> "application/x-authorware-bin";
            case "vrml" -> "model/vrml";
            case "vsd" -> "application/vnd.visio";
            case "vsf" -> "application/vnd.vsf";
            case "vss" -> "application/vnd.visio";
            case "vst" -> "application/vnd.visio";
            case "vsw" -> "application/vnd.visio";
            case "vtu" -> "model/vnd.vtu";
            case "vxml" -> "application/voicexml+xml";
            case "w3d" -> "application/x-director";
            case "wad" -> "application/x-doom";
            case "wasm" -> "application/wasm";
            case "wav" -> "audio/x-wav";
            case "wax" -> "audio/x-ms-wax";
            case "wbmp" -> "image/vnd.wap.wbmp";
            case "wbs" -> "application/vnd.criticaltools.wbs+xml";
            case "wbxml" -> "application/vnd.wap.wbxml";
            case "wcm" -> "application/vnd.ms-works";
            case "wdb" -> "application/vnd.ms-works";
            case "wdp" -> "image/vnd.ms-photo";
            case "weba" -> "audio/webm";
            case "webm" -> "video/webm";
            case "webp" -> "image/webp";
            case "wg" -> "application/vnd.pmi.widget";
            case "wgt" -> "application/widget";
            case "wks" -> "application/vnd.ms-works";
            case "wm" -> "video/x-ms-wm";
            case "wma" -> "audio/x-ms-wma";
            case "wmd" -> "application/x-ms-wmd";
            case "wmf" -> "application/x-msmetafile";
            case "wml" -> "text/vnd.wap.wml";
            case "wmlc" -> "application/vnd.wap.wmlc";
            case "wmls" -> "text/vnd.wap.wmlscript";
            case "wmlsc" -> "application/vnd.wap.wmlscriptc";
            case "wmv" -> "video/x-ms-wmv";
            case "wmx" -> "video/x-ms-wmx";
            case "wmz" -> "application/x-msmetafile";
            case "woff" -> "font/woff";
            case "woff2" -> "font/woff2";
            case "wpd" -> "application/vnd.wordperfect";
            case "wpl" -> "application/vnd.ms-wpl";
            case "wps" -> "application/vnd.ms-works";
            case "wqd" -> "application/vnd.wqd";
            case "wri" -> "application/x-mswrite";
            case "wrl" -> "model/vrml";
            case "wsdl" -> "application/wsdl+xml";
            case "wspolicy" -> "application/wspolicy+xml";
            case "wtb" -> "application/vnd.webturbo";
            case "wvx" -> "video/x-ms-wvx";
            case "x32" -> "application/x-authorware-bin";
            case "x3d" -> "model/x3d+xml";
            case "x3db" -> "model/x3d+binary";
            case "x3dbz" -> "model/x3d+binary";
            case "x3dv" -> "model/x3d+vrml";
            case "x3dvz" -> "model/x3d+vrml";
            case "x3dz" -> "model/x3d+xml";
            case "xaml" -> "application/xaml+xml";
            case "xap" -> "application/x-silverlight-app";
            case "xar" -> "application/vnd.xara";
            case "xbap" -> "application/x-ms-xbap";
            case "xbd" -> "application/vnd.fujixerox.docuworks.binder";
            case "xbm" -> "image/x-xbitmap";
            case "xdf" -> "application/xcap-diff+xml";
            case "xdm" -> "application/vnd.syncml.dm+xml";
            case "xdp" -> "application/vnd.adobe.xdp+xml";
            case "xdssc" -> "application/dssc+xml";
            case "xdw" -> "application/vnd.fujixerox.docuworks";
            case "xenc" -> "application/xenc+xml";
            case "xer" -> "application/patch-ops-error+xml";
            case "xfdf" -> "application/vnd.adobe.xfdf";
            case "xfdl" -> "application/vnd.xfdl";
            case "xht" -> "application/xhtml+xml";
            case "xhtml" -> "application/xhtml+xml";
            case "xhvml" -> "application/xv+xml";
            case "xif" -> "image/vnd.xiff";
            case "xla" -> "application/vnd.ms-excel";
            case "xlam" -> "application/vnd.ms-excel.addin.macroenabled.12";
            case "xlc" -> "application/vnd.ms-excel";
            case "xlf" -> "application/x-xliff+xml";
            case "xlm" -> "application/vnd.ms-excel";
            case "xls" -> "application/vnd.ms-excel";
            case "xlsb" -> "application/vnd.ms-excel.sheet.binary.macroenabled.12";
            case "xlsm" -> "application/vnd.ms-excel.sheet.macroenabled.12";
            case "xlsx" -> "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            case "xlt" -> "application/vnd.ms-excel";
            case "xltm" -> "application/vnd.ms-excel.template.macroenabled.12";
            case "xltx" -> "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
            case "xlw" -> "application/vnd.ms-excel";
            case "xm" -> "audio/xm";
            case "xml" -> "application/xml";
            case "xo" -> "application/vnd.olpc-sugar";
            case "xop" -> "application/xop+xml";
            case "xpi" -> "application/x-xpinstall";
            case "xpl" -> "application/xproc+xml";
            case "xpm" -> "image/x-xpixmap";
            case "xpr" -> "application/vnd.is-xpr";
            case "xps" -> "application/vnd.ms-xpsdocument";
            case "xpw" -> "application/vnd.intercon.formnet";
            case "xpx" -> "application/vnd.intercon.formnet";
            case "xsl" -> "application/xml";
            case "xslt" -> "application/xslt+xml";
            case "xsm" -> "application/vnd.syncml+xml";
            case "xspf" -> "application/xspf+xml";
            case "xul" -> "application/vnd.mozilla.xul+xml";
            case "xvm" -> "application/xv+xml";
            case "xvml" -> "application/xv+xml";
            case "xwd" -> "image/x-xwindowdump";
            case "xyz" -> "chemical/x-xyz";
            case "xz" -> "application/x-xz";
            case "yaml" -> "text/yaml";
            case "yang" -> "application/yang";
            case "yin" -> "application/yin+xml";
            case "yml" -> "text/yaml";
            case "z1" -> "application/x-zmachine";
            case "z2" -> "application/x-zmachine";
            case "z3" -> "application/x-zmachine";
            case "z4" -> "application/x-zmachine";
            case "z5" -> "application/x-zmachine";
            case "z6" -> "application/x-zmachine";
            case "z7" -> "application/x-zmachine";
            case "z8" -> "application/x-zmachine";
            case "zaz" -> "application/vnd.zzazz.deck+xml";
            case "zip" -> "application/zip";
            case "zir" -> "application/vnd.zul";
            case "zirz" -> "application/vnd.zul";
            case "zmm" -> "application/vnd.handheld-entertainment+xml";
            default -> null;
        };
    }
}

