/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.JMSException;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicSession;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.command.SessionId;

public class ActiveMQXASession
extends ActiveMQSession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    public ActiveMQXASession(ActiveMQXAConnection connection, SessionId sessionId, int theAcknowlegeMode, boolean dispatchAsync) throws JMSException {
        super(connection, sessionId, theAcknowlegeMode, dispatchAsync);
    }

    @Override
    public void rollback() throws JMSException {
        this.checkClosed();
        throw new TransactionInProgressException("Cannot rollback() inside an XASession");
    }

    @Override
    public void commit() throws JMSException {
        this.checkClosed();
        throw new TransactionInProgressException("Cannot commit() inside an XASession");
    }

    @Override
    public Session getSession() throws JMSException {
        return this;
    }

    @Override
    public XAResource getXAResource() {
        return this.getTransactionContext();
    }

    @Override
    public QueueSession getQueueSession() throws JMSException {
        return new ActiveMQQueueSession(this);
    }

    @Override
    public TopicSession getTopicSession() throws JMSException {
        return new ActiveMQTopicSession(this);
    }

    @Override
    protected void doStartTransaction() throws JMSException {
        if (this.acknowledgementMode == 0 && !this.getTransactionContext().isInXATransaction()) {
            throw new JMSException("Session's XAResource has not been enlisted in a distributed transaction.");
        }
    }
}

