/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.management.JMSConnectionStatsImpl;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.util.IndentPrinter;

public class JMSStatsImpl
extends StatsImpl {
    private List<ActiveMQConnection> connections = new CopyOnWriteArrayList<ActiveMQConnection>();

    public JMSConnectionStatsImpl[] getConnections() {
        Object[] connectionArray = this.connections.toArray();
        int size = connectionArray.length;
        JMSConnectionStatsImpl[] answer = new JMSConnectionStatsImpl[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ActiveMQConnection connection = (ActiveMQConnection)connectionArray[i2];
            answer[i2] = connection.getConnectionStats();
        }
        return answer;
    }

    public void addConnection(ActiveMQConnection connection) {
        this.connections.add(connection);
    }

    public void removeConnection(ActiveMQConnection connection) {
        this.connections.remove(connection);
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("factory {");
        out.incrementIndent();
        JMSConnectionStatsImpl[] array = this.getConnections();
        for (int i2 = 0; i2 < array.length; ++i2) {
            JMSConnectionStatsImpl connectionStat = array[i2];
            connectionStat.dump(out);
        }
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.flush();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JMSConnectionStatsImpl[] stats = this.getConnections();
        int size = stats.length;
        for (int i2 = 0; i2 < size; ++i2) {
            stats[i2].setEnabled(enabled);
        }
    }
}

