/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationNodePointer
extends AbstractXPathTest {
    private ConfigurationNodePointer<ImmutableNode> pointer;

    private void checkIterators(NodePointer p) {
        ImmutableNode node = (ImmutableNode)p.getNode();
        NodeIterator it = p.childIterator(null, false, null);
        Assertions.assertEquals((int)node.getChildren().size(), (int)this.iteratorSize(it));
        int index = 1;
        while (it.setPosition(index)) {
            NodePointer pchild = it.getNodePointer();
            Assertions.assertEquals(node.getChildren().get(index - 1), (Object)pchild.getNode());
            this.checkIterators(pchild);
            ++index;
        }
        it = p.attributeIterator(new QName(null, "*"));
        Assertions.assertEquals((int)node.getAttributes().size(), (int)this.iteratorSize(it));
        index = 1;
        while (it.setPosition(index)) {
            NodePointer pattr = it.getNodePointer();
            Assertions.assertTrue((boolean)pattr.isAttribute());
            Assertions.assertTrue((boolean)node.getAttributes().containsKey(pattr.getName().getName()));
            ++index;
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.pointer = new ConfigurationNodePointer((Object)this.root, Locale.getDefault(), this.handler);
    }

    @Test
    void testCompareChildNodePointersAttributes() {
        ImmutableNode n1 = new ImmutableNode.Builder().name("n1").create();
        ImmutableNode n2 = new ImmutableNode.Builder().name("n2").create();
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, (Object)n1, this.handler);
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, (Object)n2, this.handler);
        Assertions.assertEquals((int)0, (int)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assertions.assertEquals((int)0, (int)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    void testCompareChildNodePointersChildren() {
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, (Object)((ImmutableNode)this.root.getChildren().get(1)), this.handler);
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, (Object)((ImmutableNode)this.root.getChildren().get(3)), this.handler);
        Assertions.assertEquals((int)-1, (int)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assertions.assertEquals((int)1, (int)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    void testIsAttribute() {
        Assertions.assertFalse((boolean)this.pointer.isAttribute());
    }

    @Test
    void testIsLeafTrue() {
        ImmutableNode leafNode = new ImmutableNode.Builder().name("leafNode").create();
        this.pointer = new ConfigurationNodePointer(this.pointer, (Object)leafNode, this.handler);
        Assertions.assertTrue((boolean)this.pointer.isLeaf());
    }

    @Test
    void testIsLeave() {
        Assertions.assertFalse((boolean)this.pointer.isLeaf());
    }

    @Test
    void testIterators() {
        this.checkIterators((NodePointer)this.pointer);
    }

    @Test
    void testSetValue() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.pointer.setValue((Object)"newValue"));
    }
}

