/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.jexl3.ConcurrentCache;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.SpreadCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CachePerformanceTest {
    private static final int LOOPS = 10;
    private static final int SCRIPTS = 800;
    private static final int CACHED = 500;
    private static final int HIT = 5;
    private static final int THREADS = 8;
    Log LOGGER = LogFactory.getLog(this.getClass());

    CachePerformanceTest() {
    }

    protected void runTest(String name, JexlEngine jexl) throws Exception {
        int t;
        ExecutorService exec = Executors.newFixedThreadPool(8);
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(8);
        ArrayList<Future<Integer>> results = new ArrayList<Future<Integer>>(8);
        for (int i = 0; i < 500; ++i) {
            JexlScript script = jexl.createScript(Integer.toString(i));
            Assertions.assertNotNull((Object)script);
        }
        for (int t2 = 0; t2 < 8; ++t2) {
            results.add(exec.submit(new Task(jexl, queue)));
        }
        Timer tt = new Timer();
        tt.start();
        for (t = 0; t < 8; ++t) {
            queue.put(t);
        }
        for (t = 0; t < 8; ++t) {
            queue.put(Task.class);
        }
        int total = 0;
        for (Future future : results) {
            total += ((Integer)future.get()).intValue();
        }
        exec.shutdown();
        tt.stop();
        Assertions.assertEquals((int)total, (int)200000);
        this.LOGGER.info((Object)(name + " : " + tt.elapse()));
    }

    @Test
    void testConcurrent() throws Exception {
        JexlBuilder builder = new JexlBuilder().cacheFactory(ConcurrentCache::new).cache(500);
        JexlEngine jexl = builder.create();
        this.runTest("testConcurrent", jexl);
    }

    @Test
    void testSpread() throws Exception {
        JexlBuilder builder = new JexlBuilder().cacheFactory(SpreadCache::new).cache(500);
        JexlEngine jexl = builder.create();
        this.runTest("testSpread", jexl);
    }

    @Test
    void testSynchronized() throws Exception {
        JexlBuilder builder = new JexlBuilder().cache(500);
        JexlEngine jexl = builder.create();
        this.runTest("testSynchronized", jexl);
    }

    static class Task
    implements Callable<Integer> {
        private final JexlEngine jexl;
        private final BlockingQueue<?> queue;

        Task(JexlEngine jexl, BlockingQueue<?> queue) {
            this.jexl = jexl;
            this.queue = queue;
        }

        @Override
        public Integer call() {
            int count = 0;
            try {
                Object arg;
                while ((arg = this.queue.take()) != Task.class) {
                    Random rnd = new Random(((Integer)arg).intValue());
                    for (int l = 0; l < 10; ++l) {
                        for (int c = 0; c < 500; ++c) {
                            int ctl = rnd.nextInt(800);
                            for (int r = 0; r < 5; ++r) {
                                JexlScript script = this.jexl.createScript(Integer.toString(ctl));
                                Object result = script.execute(null);
                                Assertions.assertEquals((int)((Number)result).intValue(), (int)ctl);
                                ++count;
                            }
                        }
                    }
                }
                return count;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static class Timer {
        long begin;
        long end;

        String elapse() {
            long delta = this.end - this.begin;
            DecimalFormat fmt = new DecimalFormat("#.###");
            return fmt.format((double)delta / 1000.0);
        }

        void start() {
            this.begin = System.currentTimeMillis();
        }

        void stop() {
            this.end = System.currentTimeMillis();
        }
    }
}

