/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.IntVariance;
import org.apache.commons.statistics.descriptive.LongVariance;
import org.apache.commons.statistics.descriptive.SumOfSquaredDeviations;

class SumOfCubedDeviations
extends SumOfSquaredDeviations {
    static final int LENGTH_TWO = 2;
    protected double sumCubedDev;

    SumOfCubedDeviations() {
    }

    SumOfCubedDeviations(SumOfCubedDeviations source) {
        super(source);
        this.sumCubedDev = source.sumCubedDev;
    }

    SumOfCubedDeviations(double sc, SumOfSquaredDeviations ss) {
        super(ss);
        this.sumCubedDev = sc;
    }

    SumOfCubedDeviations(double sc, double ss, double m1, long n) {
        super(ss, m1, n);
        this.sumCubedDev = sc;
    }

    static SumOfCubedDeviations of(double ... values) {
        if (values.length == 0) {
            return new SumOfCubedDeviations();
        }
        return SumOfCubedDeviations.create(SumOfSquaredDeviations.of(values), values, 0, values.length);
    }

    static SumOfCubedDeviations ofRange(double[] values, int from, int to) {
        if (from == to) {
            return new SumOfCubedDeviations();
        }
        return SumOfCubedDeviations.create(SumOfSquaredDeviations.ofRange(values, from, to), values, from, to);
    }

    static SumOfCubedDeviations createFromRange(Sum sum, double[] values, int from, int to) {
        if (from == to) {
            return new SumOfCubedDeviations();
        }
        return SumOfCubedDeviations.create(SumOfSquaredDeviations.createFromRange(sum, values, from, to), values, from, to);
    }

    private static SumOfCubedDeviations create(SumOfSquaredDeviations ss, double[] values, int from, int to) {
        double xbar = ss.getFirstMoment();
        if (!Double.isFinite(xbar)) {
            return new SumOfCubedDeviations(Double.NaN, ss);
        }
        if (!Double.isFinite(ss.sumSquaredDev)) {
            return new SumOfCubedDeviations(ss.n <= 2L ? 0.0 : Double.NaN, ss);
        }
        double s = 0.0;
        if (ss.n > 2L) {
            for (int i = from; i < to; ++i) {
                s += SumOfCubedDeviations.pow3(values[i] - xbar);
            }
        }
        return new SumOfCubedDeviations(s, ss);
    }

    static SumOfCubedDeviations of(int ... values) {
        return SumOfCubedDeviations.ofRange(values, 0, values.length);
    }

    static SumOfCubedDeviations ofRange(int[] values, int from, int to) {
        if (from == to) {
            return new SumOfCubedDeviations();
        }
        IntVariance variance = IntVariance.createFromRange(values, from, to);
        double xbar = variance.computeMean();
        double ss = variance.computeSumOfSquaredDeviations();
        double sc = 0.0;
        if (to - from > 2) {
            for (int i = from; i < to; ++i) {
                sc += SumOfCubedDeviations.pow3((double)values[i] - xbar);
            }
        }
        return new SumOfCubedDeviations(sc, ss, xbar, to - from);
    }

    static SumOfCubedDeviations of(long ... values) {
        return SumOfCubedDeviations.ofRange(values, 0, values.length);
    }

    static SumOfCubedDeviations ofRange(long[] values, int from, int to) {
        if (from == to) {
            return new SumOfCubedDeviations();
        }
        LongVariance variance = LongVariance.createFromRange(values, from, to);
        double xbar = variance.computeMean();
        double ss = variance.computeSumOfSquaredDeviations();
        double sc = 0.0;
        if (to - from > 2) {
            for (int i = from; i < to; ++i) {
                sc += SumOfCubedDeviations.pow3((double)values[i] - xbar);
            }
        }
        return new SumOfCubedDeviations(sc, ss, xbar, to - from);
    }

    private static double pow3(double x) {
        return x * x * x;
    }

    @Override
    public void accept(double value) {
        double ss = this.sumSquaredDev;
        double np = this.n;
        super.accept(value);
        this.sumCubedDev = this.sumCubedDev - ss * this.nDev * 6.0 + (np - 1.0) * np * this.nDev * this.nDev * this.dev * 8.0;
    }

    double getSumOfCubedDeviations() {
        return Double.isFinite(this.getFirstMoment()) ? this.sumCubedDev : Double.NaN;
    }

    SumOfCubedDeviations combine(SumOfCubedDeviations other) {
        if (this.n == 0L) {
            this.sumCubedDev = other.sumCubedDev;
        } else if (other.n != 0L) {
            double halfDiffOfMean = this.getFirstMomentHalfDifference(other);
            this.sumCubedDev += other.sumCubedDev;
            if (halfDiffOfMean != 0.0) {
                double n1 = this.n;
                double n2 = other.n;
                if (n1 == n2) {
                    this.sumCubedDev += (this.sumSquaredDev - other.sumSquaredDev) * halfDiffOfMean * 3.0;
                } else {
                    double n1n2 = n1 + n2;
                    double dm = 2.0 * (halfDiffOfMean / n1n2);
                    this.sumCubedDev += (this.sumSquaredDev * n2 - other.sumSquaredDev * n1) * dm * 3.0 + (n2 - n1) * (n1 * n2) * SumOfCubedDeviations.pow3(dm) * n1n2;
                }
            }
        }
        super.combine(other);
        return this;
    }
}

