/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import org.apache.rat.ReportConfiguration;
import org.apache.rat.api.RatException;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.FileDocument;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

class ResourceCollectionContainer
implements IReportable {
    private final ResourceCollection resources;
    private final ReportConfiguration configuration;
    private final DocumentName name;

    ResourceCollectionContainer(DocumentName name, ReportConfiguration configuration, ResourceCollection resources) {
        this.resources = resources;
        this.configuration = configuration;
        this.name = name;
    }

    @Override
    public void run(RatReport report) throws RatException {
        for (Resource r : this.resources) {
            if (!r.isFilesystemOnly()) continue;
            FileResource fr = (FileResource)r;
            DocumentName dirName = DocumentName.builder(fr.getFile()).setBaseName(fr.getProject().getBaseDir()).build();
            FileDocument document = new FileDocument(dirName, fr.getFile(), this.configuration.getDocumentExcluder(dirName));
            report.report(document);
        }
    }

    @Override
    public DocumentName getName() {
        return this.name;
    }
}

