/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.servant;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class EJBServantConfig {
    private String jndiName;
    private QName serviceName;
    private String wsdlURL;

    public EJBServantConfig(String jndiName, String value) {
        this.jndiName = jndiName;
        StringTokenizer st = new StringTokenizer(value, "@", true);
        if (st.hasMoreTokens()) {
            String theValue = st.nextToken().trim();
            if ("@".equals(theValue)) {
                if (st.hasMoreTokens()) {
                    this.wsdlURL = st.nextToken().trim();
                }
            } else {
                this.serviceName = this.getServiceName(theValue);
                if (st.hasMoreTokens() && "@".equals(st.nextToken()) && st.hasMoreTokens()) {
                    this.wsdlURL = st.nextToken().trim();
                }
            }
        }
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    private QName getServiceName(String sname) {
        StringTokenizer st = new StringTokenizer(sname, "}", false);
        String namespace = "";
        String localpart = "";
        if (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            if (value.startsWith("{")) {
                namespace = value.substring(1);
            } else {
                localpart = value;
            }
        }
        if (st.hasMoreTokens()) {
            localpart = st.nextToken().trim();
        }
        return new QName(namespace, localpart);
    }
}

