/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.JGroupsFileBroadcastGroupControl;
import org.apache.activemq.artemis.core.management.impl.BaseBroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.logs.AuditLogger;

public class JGroupsFileBroadcastGroupControlImpl
extends BaseBroadcastGroupControlImpl
implements JGroupsFileBroadcastGroupControl {
    private JGroupsFileBroadcastEndpointFactory endpointFactory;

    public JGroupsFileBroadcastGroupControlImpl(BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration, JGroupsFileBroadcastEndpointFactory endpointFactory) throws Exception {
        super(JGroupsFileBroadcastGroupControl.class, broadcastGroup, storageManager, configuration);
        this.endpointFactory = endpointFactory;
    }

    public String getFileContents() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFileContents((Object)this.getBroadcastGroup());
        }
        URL resource = this.getClass().getClassLoader().getResource(this.getFile());
        File file = new File(resource.getFile());
        return new String(Files.readAllBytes(Paths.get(file.getPath(), new String[0])));
    }

    public String getChannelName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getChannelName((Object)this.getBroadcastGroup());
        }
        return this.endpointFactory.getChannelName();
    }

    public String getFile() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFile((Object)this.getBroadcastGroup());
        }
        return this.endpointFactory.getFile();
    }
}

