/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpHandler;
import io.undertow.server.session.Session;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import jakarta.servlet.ServletContext;
import java.security.AccessController;

final class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    static void setContextClassLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            });
        }
    }

    static String getSystemProperty(String prop) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(prop);
        }
        return (String)AccessController.doPrivileged(() -> System.getProperty(prop));
    }

    static HttpSessionImpl forSession(Session session, ServletContext servletContext, boolean newSession) {
        if (System.getSecurityManager() == null) {
            return HttpSessionImpl.forSession(session, servletContext, newSession);
        }
        return AccessController.doPrivileged(() -> HttpSessionImpl.forSession(session, servletContext, newSession));
    }

    static ServletRequestContext currentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.current();
        }
        return AccessController.doPrivileged(ServletRequestContext::current);
    }

    static void setCurrentRequestContext(ServletRequestContext servletRequestContext) {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.setCurrentRequestContext(servletRequestContext);
        } else {
            AccessController.doPrivileged(() -> {
                ServletRequestContext.setCurrentRequestContext(servletRequestContext);
                return null;
            });
        }
    }

    static ServletInitialHandler createServletInitialHandler(ServletPathMatches paths, HttpHandler next, Deployment deployment, ServletContextImpl servletContext) {
        if (System.getSecurityManager() == null) {
            return new ServletInitialHandler(paths, next, deployment, servletContext);
        }
        return AccessController.doPrivileged(() -> new ServletInitialHandler(paths, next, deployment, servletContext));
    }
}

