/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.impl.EntityPartImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

public class EntityPartBuilderImpl
implements EntityPart.Builder {
    private final String name;
    private MediaType mediaType;
    private MultivaluedMap<String, String> headers = new MultivaluedHashMap();
    private String fileName;
    private Object content;
    private GenericType<?> genericType;
    private Class<?> type;

    public EntityPartBuilderImpl(String name) {
        this.name = name;
    }

    public EntityPart.Builder mediaType(MediaType mt) throws IllegalArgumentException {
        this.mediaType = mt;
        return this;
    }

    public EntityPart.Builder mediaType(String mts) throws IllegalArgumentException {
        this.mediaType = MediaType.valueOf((String)mts);
        return this;
    }

    public EntityPart.Builder header(String headerName, String ... headerValues) throws IllegalArgumentException {
        this.headers.addAll((Object)headerName, (Object[])headerValues);
        return this;
    }

    public EntityPart.Builder headers(MultivaluedMap<String, String> newHeaders) throws IllegalArgumentException {
        this.headers.clear();
        this.headers.putAll(newHeaders);
        return this;
    }

    public EntityPart.Builder fileName(String fn) throws IllegalArgumentException {
        this.fileName = fn;
        return this;
    }

    public EntityPart.Builder content(InputStream in) throws IllegalArgumentException {
        this.content = in;
        return this;
    }

    public <T> EntityPart.Builder content(T c, Class<? extends T> t) throws IllegalArgumentException {
        this.content = c;
        this.type = t;
        this.genericType = null;
        return this;
    }

    public <T> EntityPart.Builder content(T c, GenericType<T> t) throws IllegalArgumentException {
        this.content = c;
        this.genericType = t;
        this.type = null;
        return this;
    }

    public EntityPart build() throws IllegalStateException, IOException, WebApplicationException {
        return new EntityPartImpl(EntityPartBuilderImpl.getProviderFactory(), this.name, this.fileName, this.content, this.type, this.genericType, this.headers, this.mediaType);
    }

    private static Providers getProviderFactory() {
        Message message = JAXRSUtils.getCurrentMessage();
        if (message == null) {
            return new ReaderWriterProviders(ServerProviderFactory.createInstance(BusFactory.getThreadDefaultBus()));
        }
        return new ReaderWriterProviders(ProviderFactory.getInstance(message));
    }

    private static final class ReaderWriterProviders
    implements Providers {
        private final ProviderFactory factory;

        private ReaderWriterProviders(ProviderFactory factory) {
            this.factory = factory;
        }

        public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.factory.createMessageBodyWriter(type, genericType, annotations, mediaType, ReaderWriterProviders.getCurrentMessage());
        }

        public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.factory.createMessageBodyReader(type, genericType, annotations, mediaType, ReaderWriterProviders.getCurrentMessage());
        }

        public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
            throw new UnsupportedOperationException();
        }

        public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
            throw new UnsupportedOperationException();
        }

        private static Message getCurrentMessage() {
            Message message = JAXRSUtils.getCurrentMessage();
            if (message == null) {
                message = new MessageImpl();
            }
            return message;
        }
    }
}

