/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.xmlpull;

import com.siemens.ct.exi.core.EXIBodyDecoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamDecoder;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.event.EventType;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EXIPullParser
implements XmlPullParser {
    protected final EXIFactory factory;
    protected final EXIStreamDecoder exiStream;
    protected EXIBodyDecoder decoder;
    protected EventType eventType;
    protected EventType preReadEventType;
    protected QNameContext element;
    protected List<AttributeContainer> attributes;
    protected Value characters;
    protected DocType docType;
    protected char[] entityReference;
    protected char[] comment;
    protected ProcessingInstruction processingInstruction;
    String endElementPrefix;

    public EXIPullParser(EXIFactory factory) throws EXIException {
        this.factory = factory;
        this.exiStream = factory.createEXIStreamDecoder();
        this.attributes = new ArrayList<AttributeContainer>();
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        throw new XmlPullParserException("EXI does not support setting feature " + name + " to " + state);
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new XmlPullParserException("EXI does not support setting property " + name + " to " + value);
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setInput(Reader in) throws XmlPullParserException {
        throw new XmlPullParserException("EXI requires byte-based stream. Consider using InputStream.");
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        try {
            this.parseHeader(inputStream);
        }
        catch (EXIException e) {
            throw new XmlPullParserException("[EXI] " + e.getMessage());
        }
        catch (IOException e) {
            throw new XmlPullParserException("[EXI] " + e.getMessage());
        }
    }

    protected void parseHeader(InputStream is) throws EXIException, IOException {
        assert (is != null);
        assert (this.exiStream != null);
        this.decoder = this.exiStream.decodeHeader(is);
        this.initForEachRun();
        this.eventType = this.decoder.next();
        assert (this.eventType == EventType.START_DOCUMENT);
        this.decoder.decodeStartDocument();
    }

    protected void initForEachRun() {
        this.eventType = null;
        this.preReadEventType = null;
        this.attributes.clear();
    }

    public String getInputEncoding() {
        return null;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        List ns = this.decoder.getDeclaredPrefixDeclarations();
        if (ns == null) {
            return 0;
        }
        return ns.size();
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        List ns = this.decoder.getDeclaredPrefixDeclarations();
        if (ns == null || pos >= ns.size()) {
            return null;
        }
        return ((NamespaceDeclaration)ns.get((int)pos)).prefix;
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        List ns = this.decoder.getDeclaredPrefixDeclarations();
        if (ns == null || pos >= ns.size()) {
            return null;
        }
        return ((NamespaceDeclaration)ns.get((int)pos)).namespaceURI;
    }

    public String getNamespace(String prefix) {
        if (prefix == null) {
            return null;
        }
        List ns = this.decoder.getDeclaredPrefixDeclarations();
        if (ns != null) {
            for (int i = ns.size() - 1; i >= 0; --i) {
                if (!prefix.equals(((NamespaceDeclaration)ns.get((int)i)).prefix)) continue;
                return ((NamespaceDeclaration)ns.get((int)i)).namespaceURI;
            }
        }
        return null;
    }

    public int getDepth() {
        return 0;
    }

    public String getPositionDescription() {
        return null;
    }

    public int getLineNumber() {
        return 0;
    }

    public int getColumnNumber() {
        return 0;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        switch (this.getEventType()) {
            case 4: {
                return this.characters.toString().trim().length() == 0;
            }
            case 5: {
                return false;
            }
            case 9: {
                return false;
            }
        }
        return false;
    }

    public String getText() {
        try {
            switch (this.getEventType()) {
                case 4: {
                    return this.characters.toString();
                }
                case 9: {
                    return new String(this.comment);
                }
                case 6: {
                    return new String(this.entityReference);
                }
                case 10: {
                    return this.getDocTypeString();
                }
            }
            throw new RuntimeException("Unexpected event, id=" + this.getEventType());
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Unexpected text, error=" + e.getMessage());
        }
    }

    private String getDocTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ");
        sb.append(this.docType.name);
        if (this.docType.publicID.length > 0) {
            sb.append(" PUBLIC ");
            sb.append('\"');
            sb.append(this.docType.publicID);
            sb.append('\"');
        }
        if (this.docType.systemID.length > 0) {
            if (this.docType.publicID.length == 0) {
                sb.append(" SYSTEM ");
            } else {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(this.docType.systemID);
            sb.append('\"');
        }
        if (this.docType.text.length > 0) {
            sb.append(' ');
            sb.append('[');
            sb.append(this.docType.text);
            sb.append(']');
        }
        sb.append('>');
        return sb.toString();
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        char[] ch = this.getText().toCharArray();
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = ch.length;
        return ch;
    }

    public String getNamespace() {
        int et = EXIPullParser.getEventType(this.eventType);
        if (et == 2 || et == 3) {
            return this.element.getNamespaceUri();
        }
        return null;
    }

    public String getName() {
        int et = EXIPullParser.getEventType(this.eventType);
        if (et == 2 || et == 3) {
            return this.element.getLocalName();
        }
        if (et == 6) {
            return new String(this.entityReference);
        }
        return null;
    }

    public String getPrefix() {
        int et = EXIPullParser.getEventType(this.eventType);
        if (et == 2 || et == 3) {
            if (this.endElementPrefix != null) {
                return this.endElementPrefix;
            }
            return this.decoder.getElementPrefix();
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return false;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttributeNamespace(int index) {
        if (index >= 0 && index < this.attributes.size()) {
            return this.attributes.get((int)index).qname.getNamespaceUri();
        }
        return null;
    }

    public String getAttributeName(int index) {
        if (index >= 0 && index < this.attributes.size()) {
            return this.attributes.get((int)index).qname.getLocalName();
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        if (index >= 0 && index < this.attributes.size()) {
            return this.attributes.get((int)index).prefix;
        }
        return null;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public String getAttributeValue(int index) {
        if (index >= 0 && index < this.attributes.size()) {
            return this.attributes.get((int)index).value.toString();
        }
        return null;
    }

    public String getAttributeValue(String namespace, String name) {
        if (name == null) {
            return null;
        }
        if (namespace == null) {
            namespace = "";
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get((int)i).qname.getNamespaceUri().equals(namespace) || !this.attributes.get((int)i).qname.getLocalName().equals(name)) continue;
            return this.attributes.get((int)i).value.toString();
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return EXIPullParser.getEventType(this.eventType);
    }

    protected static int getEventType(EventType eventType) {
        assert (eventType != null);
        switch (eventType) {
            case START_DOCUMENT: {
                return 0;
            }
            case ATTRIBUTE_XSI_TYPE: 
            case ATTRIBUTE_XSI_NIL: 
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                return -2;
            }
            case START_ELEMENT: 
            case START_ELEMENT_NS: 
            case START_ELEMENT_GENERIC: 
            case START_ELEMENT_GENERIC_UNDECLARED: {
                return 2;
            }
            case END_ELEMENT: 
            case END_ELEMENT_UNDECLARED: {
                return 3;
            }
            case CHARACTERS: 
            case CHARACTERS_GENERIC: 
            case CHARACTERS_GENERIC_UNDECLARED: {
                return 4;
            }
            case END_DOCUMENT: {
                return 1;
            }
            case DOC_TYPE: {
                return 10;
            }
            case NAMESPACE_DECLARATION: {
                return -3;
            }
            case SELF_CONTAINED: {
                return -1;
            }
            case ENTITY_REFERENCE: {
                return 6;
            }
            case COMMENT: {
                return 9;
            }
            case PROCESSING_INSTRUCTION: {
                return 8;
            }
        }
        throw new RuntimeException("Unexpected EXI Event '" + eventType + "' ");
    }

    public int next() throws XmlPullParserException, IOException {
        return this.nextToken();
    }

    protected EventType decodeEvent(EventType nextEventType) throws EXIException, IOException {
        this.endElementPrefix = null;
        switch (nextEventType) {
            case START_DOCUMENT: {
                this.decoder.decodeStartDocument();
                break;
            }
            case END_DOCUMENT: {
                this.decoder.decodeEndDocument();
                break;
            }
            case ATTRIBUTE_XSI_NIL: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttributeXsiNil(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case ATTRIBUTE_XSI_TYPE: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttributeXsiType(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttribute(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case NAMESPACE_DECLARATION: {
                this.decoder.decodeNamespaceDeclaration();
                break;
            }
            case SELF_CONTAINED: {
                this.decoder.decodeStartSelfContainedFragment();
                break;
            }
            case START_ELEMENT: 
            case START_ELEMENT_NS: 
            case START_ELEMENT_GENERIC: 
            case START_ELEMENT_GENERIC_UNDECLARED: {
                this.element = this.decoder.decodeStartElement();
                break;
            }
            case END_ELEMENT: 
            case END_ELEMENT_UNDECLARED: {
                this.endElementPrefix = this.decoder.getElementPrefix();
                this.element = this.decoder.decodeEndElement();
                break;
            }
            case CHARACTERS: 
            case CHARACTERS_GENERIC: 
            case CHARACTERS_GENERIC_UNDECLARED: {
                this.characters = this.decoder.decodeCharacters();
                break;
            }
            case DOC_TYPE: {
                this.docType = this.decoder.decodeDocType();
                break;
            }
            case ENTITY_REFERENCE: {
                this.entityReference = this.decoder.decodeEntityReference();
                break;
            }
            case COMMENT: {
                this.comment = this.decoder.decodeComment();
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.processingInstruction = this.decoder.decodeProcessingInstruction();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected EXI Event '" + this.eventType + "' ");
            }
        }
        return nextEventType;
    }

    protected void handleAttributes() throws EXIException, IOException, XmlPullParserException {
        EventType et;
        assert (this.getEventType() == 2);
        this.attributes.clear();
        do {
            if (!this.isAttributeEvent(et = this.decoder.next())) continue;
            this.decodeEvent(et);
        } while (this.isAttributeEvent(et));
        this.preReadEventType = et;
    }

    private boolean isAttributeEvent(EventType et) {
        boolean isAttributeEvent = false;
        switch (et) {
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                isAttributeEvent = true;
                break;
            }
            case NAMESPACE_DECLARATION: {
                isAttributeEvent = true;
                break;
            }
            case SELF_CONTAINED: {
                isAttributeEvent = true;
                break;
            }
        }
        return isAttributeEvent;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        try {
            if (this.preReadEventType == null) {
                this.eventType = this.decodeEvent(this.decoder.next());
            } else {
                this.eventType = this.preReadEventType;
                this.preReadEventType = null;
                this.decodeEvent(this.eventType);
            }
            int ev = this.getEventType();
            if (ev == 2) {
                this.handleAttributes();
            }
            return ev;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", (XmlPullParser)this, null);
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException("event TEXT it must be immediately followed by END_TAG", (XmlPullParser)this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", (XmlPullParser)this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected start or end tag", (XmlPullParser)this, null);
        }
        return eventType;
    }

    static class AttributeContainer {
        final QNameContext qname;
        final Value value;
        final String prefix;

        public AttributeContainer(QNameContext qname, Value value, String prefix) {
            this.qname = qname;
            this.value = value;
            this.prefix = prefix;
        }
    }
}

