/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.schema;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.util.List;
import org.apache.bifromq.dist.rpc.proto.MatchRoute;
import org.apache.bifromq.dist.rpc.proto.RouteGroup;
import org.apache.bifromq.dist.worker.schema.KVSchemaConstants;
import org.apache.bifromq.dist.worker.schema.cache.GroupMatchingCache;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.dist.worker.schema.cache.NormalMatchingCache;
import org.apache.bifromq.dist.worker.schema.cache.RouteDetail;
import org.apache.bifromq.dist.worker.schema.cache.RouteDetailCache;
import org.apache.bifromq.dist.worker.schema.cache.RouteGroupCache;
import org.apache.bifromq.type.RouteMatcher;
import org.apache.bifromq.util.BSUtil;

public class KVSchemaUtil {
    public static String toReceiverUrl(MatchRoute route) {
        return KVSchemaUtil.toReceiverUrl(route.getBrokerId(), route.getReceiverId(), route.getDelivererKey());
    }

    public static String toReceiverUrl(int subBrokerId, String receiverId, String delivererKey) {
        return subBrokerId + "\u0000" + receiverId + "\u0000" + delivererKey;
    }

    public static String parseTenantId(ByteString routeKey) {
        short tenantIdLen = RouteDetailCache.tenantIdLen(routeKey);
        int tenantIdStartIdx = KVSchemaConstants.SCHEMA_VER.size() + 2;
        return routeKey.substring(tenantIdStartIdx, tenantIdStartIdx + tenantIdLen).toStringUtf8();
    }

    public static byte parseFlag(ByteString routeKey) {
        short receiverBytesLen = RouteDetailCache.receiverBytesLen(routeKey);
        int receiverBytesStartIdx = routeKey.size() - 2 - receiverBytesLen;
        int flagByteIdx = receiverBytesStartIdx - 1;
        return routeKey.byteAt(flagByteIdx);
    }

    public static Matching buildMatchRoute(ByteString routeKey, ByteString routeValue) {
        RouteDetail routeDetail = RouteDetailCache.get(routeKey);
        if (routeDetail.matcher().getType() == RouteMatcher.Type.Normal) {
            return KVSchemaUtil.buildNormalMatchRoute(routeDetail, BSUtil.toLong((ByteString)routeValue));
        }
        return KVSchemaUtil.buildGroupMatchRoute(routeDetail, RouteGroupCache.get(routeValue));
    }

    public static Matching buildNormalMatchRoute(RouteDetail routeDetail, long incarnation) {
        assert (routeDetail.matcher().getType() == RouteMatcher.Type.Normal);
        return NormalMatchingCache.get(routeDetail, incarnation);
    }

    public static Matching buildGroupMatchRoute(RouteDetail routeDetail, RouteGroup group) {
        assert (routeDetail.matcher().getType() != RouteMatcher.Type.Normal);
        return GroupMatchingCache.get(routeDetail, group);
    }

    public static ByteString tenantBeginKey(String tenantId) {
        ByteString tenantIdBytes = ByteString.copyFromUtf8((String)tenantId);
        return KVSchemaConstants.SCHEMA_VER.concat(BSUtil.toByteString((short)((short)tenantIdBytes.size())).concat(tenantIdBytes));
    }

    public static ByteString tenantRouteStartKey(String tenantId, List<String> filterLevels) {
        ByteString key = KVSchemaUtil.tenantBeginKey(tenantId);
        for (String filterLevel : filterLevels) {
            key = key.concat(ByteString.copyFromUtf8((String)filterLevel)).concat(KVSchemaConstants.SEPARATOR_BYTE);
        }
        return key.concat(KVSchemaConstants.SEPARATOR_BYTE);
    }

    private static ByteString tenantRouteBucketStartKey(String tenantId, List<String> filterLevels, byte bucket) {
        return KVSchemaUtil.tenantRouteStartKey(tenantId, filterLevels).concat(UnsafeByteOperations.unsafeWrap((byte[])new byte[]{bucket}));
    }

    public static ByteString toNormalRouteKey(String tenantId, RouteMatcher routeMatcher, String receiverUrl) {
        assert (routeMatcher.getType() == RouteMatcher.Type.Normal);
        return KVSchemaUtil.tenantRouteBucketStartKey(tenantId, (List<String>)routeMatcher.getFilterLevelList(), KVSchemaUtil.bucket(receiverUrl)).concat(KVSchemaConstants.FLAG_NORMAL_VAL).concat(KVSchemaUtil.toReceiverBytes(receiverUrl));
    }

    public static ByteString toGroupRouteKey(String tenantId, RouteMatcher routeMatcher) {
        assert (routeMatcher.getType() != RouteMatcher.Type.Normal);
        return KVSchemaUtil.tenantRouteBucketStartKey(tenantId, (List<String>)routeMatcher.getFilterLevelList(), KVSchemaUtil.bucket(routeMatcher.getGroup())).concat(routeMatcher.getType() == RouteMatcher.Type.OrderedShare ? KVSchemaConstants.FLAG_ORDERED_VAL : KVSchemaConstants.FLAG_UNORDERED_VAL).concat(KVSchemaUtil.toReceiverBytes(routeMatcher.getGroup()));
    }

    private static ByteString toReceiverBytes(String receiver) {
        ByteString b = ByteString.copyFromUtf8((String)receiver);
        return b.concat(BSUtil.toByteString((short)((short)b.size())));
    }

    private static byte bucket(String receiver) {
        int hash = receiver.hashCode();
        return (byte)((hash ^ hash >>> 16) & 0xFF);
    }
}

