/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.bifromq.basecrdt.core.api.AWORSetOperation;
import org.apache.bifromq.basecrdt.core.api.CCounterOperation;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.DWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.EWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.core.api.RWORSetOperation;
import org.apache.bifromq.basecrdt.core.internal.AWORSetCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.CCounterCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.DWFlagCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.DotFunc;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.DotSet;
import org.apache.bifromq.basecrdt.core.internal.EWFlagCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotFunc;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IDotSet;
import org.apache.bifromq.basecrdt.core.internal.IDotStore;
import org.apache.bifromq.basecrdt.core.internal.MVRegCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.ORMapUtil;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.core.internal.RWORSetCoalesceOperation;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.Replacement;

class ORMapCoalesceOperation
implements ICoalesceOperation<IDotMap, ORMapOperation> {
    private final ByteString replicaId;
    private final Map<ByteString, ValueOperation<? extends IDotStore, ? extends ICRDTOperation>> valueOps = Maps.newConcurrentMap();

    ORMapCoalesceOperation(ByteString replicaId, ORMapOperation op) {
        this.replicaId = replicaId;
        this.coalesce(op);
    }

    private ORMapCoalesceOperation(ByteString replicaId) {
        this.replicaId = replicaId;
    }

    @Override
    public Iterable<Replacement> delta(IDotMap current, ICoalesceOperation.IEventGenerator eventGenerator) {
        LinkedList dotItrs = Lists.newLinkedList();
        block5: for (Map.Entry<ByteString, ValueOperation<? extends IDotStore, ? extends ICRDTOperation>> entry : this.valueOps.entrySet()) {
            ByteString internalKey = entry.getKey();
            ValueOperation<? extends IDotStore, ? extends ICRDTOperation> valOp = entry.getValue();
            switch (ORMapUtil.getType(internalKey)) {
                case aworset: 
                case rworset: 
                case ormap: 
                case cctr: {
                    Object valueDotMap;
                    if (valOp.removeAtFirst && ((Optional)(valueDotMap = current.subDotMap(internalKey))).isPresent() && !((IDotMap)((Optional)valueDotMap).get()).isBottom()) {
                        dotItrs.add(ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, eventGenerator.nextEvent()), (Iterable)((Optional)valueDotMap).get()));
                    }
                    if (valOp.op == null) continue block5;
                    valueDotMap = valOp.removeAtFirst ? DotMap.BOTTOM : current.subDotMap(internalKey).orElse(DotMap.BOTTOM);
                    dotItrs.add(Iterables.transform(valOp.op.delta(valueDotMap, eventGenerator), replacement -> {
                        Dot dot = replacement.getDots(0);
                        if (dot.hasLattice()) {
                            return replacement.toBuilder().setDots(0, dot.toBuilder().setLattice(ProtoUtils.singleMap(internalKey, dot.getLattice())).build()).build();
                        }
                        return replacement;
                    }));
                    continue block5;
                }
                case dwflag: 
                case ewflag: {
                    Object valueDotSet;
                    if (valOp.removeAtFirst && ((Optional)(valueDotSet = current.subDotSet(internalKey))).isPresent() && !((IDotSet)((Optional)valueDotSet).get()).isBottom()) {
                        dotItrs.add(ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, eventGenerator.nextEvent()), (Iterable)((Optional)valueDotSet).get()));
                    }
                    if (valOp.op == null) continue block5;
                    valueDotSet = valOp.removeAtFirst ? DotSet.BOTTOM : current.subDotSet(internalKey).orElse(DotSet.BOTTOM);
                    dotItrs.add(Iterables.transform(valOp.op.delta(valueDotSet, eventGenerator), replacement -> {
                        Dot dot = replacement.getDots(0);
                        if (dot.hasLattice()) {
                            return replacement.toBuilder().setDots(0, dot.toBuilder().setLattice(ProtoUtils.singleMap(internalKey, dot.getLattice())).build()).build();
                        }
                        return replacement;
                    }));
                    continue block5;
                }
                case mvreg: {
                    Object valueDotFunc;
                    if (valOp.removeAtFirst && ((Optional)(valueDotFunc = current.subDotFunc(internalKey))).isPresent() && !((IDotFunc)((Optional)valueDotFunc).get()).isBottom()) {
                        dotItrs.add(ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, eventGenerator.nextEvent()), (Iterable)((Optional)valueDotFunc).get()));
                    }
                    if (valOp.op == null) continue block5;
                    valueDotFunc = valOp.removeAtFirst ? DotFunc.BOTTOM : current.subDotFunc(internalKey).orElse(DotFunc.BOTTOM);
                    dotItrs.add(Iterables.transform(valOp.op.delta(valueDotFunc, eventGenerator), replacement -> {
                        Dot dot = replacement.getDots(0);
                        if (dot.hasLattice()) {
                            return replacement.toBuilder().setDots(0, dot.toBuilder().setLattice(ProtoUtils.singleMap(internalKey, dot.getLattice())).build()).build();
                        }
                        return replacement;
                    }));
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown crdt type: " + String.valueOf((Object)ORMapUtil.getType(internalKey)));
        }
        return Iterables.concat((Iterable)dotItrs);
    }

    @Override
    public void coalesce(ORMapOperation op) {
        this.coalesce(0, op);
    }

    private void coalesce(int pathIdx, ORMapOperation op) {
        switch (op.type) {
            case UpdateKey: {
                ORMapOperation.ORMapUpdate update = (ORMapOperation.ORMapUpdate)op;
                ByteString[] keyPath = update.keyPath;
                if (pathIdx < keyPath.length - 1) {
                    ByteString typedKey = this.toTypedKey(keyPath[pathIdx], op);
                    ((ORMapCoalesceOperation)this.valueOps.computeIfAbsent((ByteString)typedKey, (Function<ByteString, ValueOperation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$coalesce$3(com.google.protobuf.ByteString ), (Lcom/google/protobuf/ByteString;)Lorg/apache/bifromq/basecrdt/core/internal/ORMapCoalesceOperation$ValueOperation;)((ORMapCoalesceOperation)this)).op).coalesce(pathIdx + 1, op);
                    break;
                }
                ByteString typedKey = this.toTypedKey(keyPath[pathIdx], (ICRDTOperation)update.valueOp);
                if (!this.valueOps.containsKey(typedKey)) {
                    this.valueOps.put(typedKey, new ValueOperation(this.startCoalesce((ICRDTOperation)update.valueOp)));
                    break;
                }
                if (this.valueOps.get((Object)typedKey).op == null) {
                    this.valueOps.get((Object)typedKey).op = this.startCoalesce((ICRDTOperation)update.valueOp);
                    break;
                }
                this.valueOps.get((Object)typedKey).op.coalesce(update.valueOp);
                break;
            }
            case RemoveKey: {
                ORMapOperation.ORMapRemove remove = (ORMapOperation.ORMapRemove)op;
                ByteString[] keyPath = remove.keyPath;
                if (pathIdx < keyPath.length - 1) {
                    ByteString typedKey = this.toTypedKey(keyPath[pathIdx], op);
                    ValueOperation pathValOperation = this.valueOps.computeIfAbsent(typedKey, k -> new ValueOperation<IDotMap, ORMapOperation>(new ORMapCoalesceOperation(this.replicaId), false));
                    ((ORMapCoalesceOperation)pathValOperation.op).coalesce(pathIdx + 1, op);
                    break;
                }
                ByteString typedKey = ORMapUtil.typedKey(keyPath[pathIdx], remove.valueType);
                if (!this.valueOps.containsKey(typedKey)) {
                    this.valueOps.put(typedKey, new ValueOperation(true));
                    break;
                }
                this.valueOps.get((Object)typedKey).removeAtFirst = true;
                this.valueOps.get((Object)typedKey).op = null;
            }
        }
    }

    private CausalCRDTType ofType(ICRDTOperation op) {
        if (op instanceof AWORSetOperation) {
            return CausalCRDTType.aworset;
        }
        if (op instanceof CCounterOperation) {
            return CausalCRDTType.cctr;
        }
        if (op instanceof DWFlagOperation) {
            return CausalCRDTType.dwflag;
        }
        if (op instanceof EWFlagOperation) {
            return CausalCRDTType.ewflag;
        }
        if (op instanceof RWORSetOperation) {
            return CausalCRDTType.rworset;
        }
        if (op instanceof ORMapOperation) {
            return CausalCRDTType.ormap;
        }
        if (op instanceof MVRegOperation) {
            return CausalCRDTType.mvreg;
        }
        throw new UnsupportedOperationException("Unknown operation type");
    }

    private ByteString toTypedKey(ByteString key, ICRDTOperation op) {
        return ORMapUtil.typedKey(key, this.ofType(op));
    }

    private ICoalesceOperation startCoalesce(ICRDTOperation op) {
        if (op instanceof AWORSetOperation) {
            return new AWORSetCoalesceOperation(this.replicaId, (AWORSetOperation)op);
        }
        if (op instanceof CCounterOperation) {
            return new CCounterCoalesceOperation(this.replicaId, (CCounterOperation)op);
        }
        if (op instanceof DWFlagOperation) {
            return new DWFlagCoalesceOperation(this.replicaId, (DWFlagOperation)op);
        }
        if (op instanceof EWFlagOperation) {
            return new EWFlagCoalesceOperation(this.replicaId, (EWFlagOperation)op);
        }
        if (op instanceof RWORSetOperation) {
            return new RWORSetCoalesceOperation(this.replicaId, (RWORSetOperation)op);
        }
        if (op instanceof ORMapOperation) {
            return new ORMapCoalesceOperation(this.replicaId, (ORMapOperation)op);
        }
        if (op instanceof MVRegOperation) {
            return new MVRegCoalesceOperation(this.replicaId, (MVRegOperation)op);
        }
        throw new UnsupportedOperationException("Unknown operation type");
    }

    private /* synthetic */ ValueOperation lambda$coalesce$3(ByteString k) {
        return new ValueOperation<IDotMap, ORMapOperation>(new ORMapCoalesceOperation(this.replicaId));
    }

    private static class ValueOperation<T extends IDotStore, O extends ICRDTOperation> {
        ICoalesceOperation<T, O> op;
        boolean removeAtFirst;

        ValueOperation(ICoalesceOperation<T, O> op) {
            this.op = op;
        }

        ValueOperation(boolean removeAtFirst) {
            this.removeAtFirst = removeAtFirst;
        }

        ValueOperation(ICoalesceOperation<T, O> op, boolean removeAtFirst) {
            this.op = op;
            this.removeAtFirst = removeAtFirst;
        }
    }
}

