/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.jackson.runtime.JacksonBuildTimeConfig;
import io.quarkus.jackson.runtime.JacksonSupport;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.TimeZone;

@Singleton
public class ConfigurationCustomizer
implements ObjectMapperCustomizer {
    @Inject
    JacksonBuildTimeConfig jacksonBuildTimeConfig;
    @Inject
    JacksonSupport jacksonSupport;

    @Override
    public void customize(ObjectMapper objectMapper) {
        ZoneId zoneId;
        JsonInclude.Include serializationInclusion;
        if (!this.jacksonBuildTimeConfig.failOnUnknownProperties()) {
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        if (!this.jacksonBuildTimeConfig.failOnEmptyBeans()) {
            objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        }
        if (!this.jacksonBuildTimeConfig.writeDatesAsTimestamps()) {
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        if (!this.jacksonBuildTimeConfig.writeDurationsAsTimestamps()) {
            objectMapper.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        }
        if (this.jacksonBuildTimeConfig.acceptCaseInsensitiveEnums()) {
            objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        }
        if ((serializationInclusion = (JsonInclude.Include)this.jacksonBuildTimeConfig.serializationInclusion().orElse(null)) != null) {
            objectMapper.setSerializationInclusion(serializationInclusion);
        }
        if (!(zoneId = this.jacksonBuildTimeConfig.timezone()).getId().equals("UTC")) {
            objectMapper.setTimeZone(TimeZone.getTimeZone(zoneId));
        }
        if (this.jacksonSupport.configuredNamingStrategy().isPresent()) {
            objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)this.jacksonSupport.configuredNamingStrategy().get());
        }
    }

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }
}

