/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.exception;

import com.azure.core.exception.AzureException;
import com.azure.core.exception.HttpResponseException;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.StorageException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CherrypickAncestorCommitException;
import org.apache.iceberg.exceptions.CleanableFailure;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.DuplicateWAPCommitException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.core.exceptions.FileIOUnknownHostException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Provider
public class IcebergExceptionMapper
implements ExceptionMapper<RuntimeException> {
    public static final int UNKNOWN_CLOUD_HTTP_CODE = -1;
    public static final Set<Integer> RETRYABLE_AZURE_HTTP_CODES = Set.of(Integer.valueOf(Response.Status.REQUEST_TIMEOUT.getStatusCode()), Integer.valueOf(Response.Status.TOO_MANY_REQUESTS.getStatusCode()), Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), Integer.valueOf(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()), Integer.valueOf(Response.Status.GATEWAY_TIMEOUT.getStatusCode()), Integer.valueOf(-1));
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergExceptionMapper.class);
    private static final Set<String> ACCESS_DENIED_HINTS = Set.of("access denied", "not authorized", "forbidden");

    public Response toResponse(RuntimeException runtimeException) {
        LOGGER.info("Handling runtimeException {}", (Object)runtimeException.getMessage());
        int responseCode = IcebergExceptionMapper.mapExceptionToResponseCode(runtimeException);
        if (responseCode == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            this.getLoggerForExceptionLogging().error("Unhandled exception returning INTERNAL_SERVER_ERROR", (Throwable)runtimeException);
        } else {
            this.getLoggerForExceptionLogging().atLevel(responseCode > 500 ? Level.INFO : Level.DEBUG).setCause((Throwable)runtimeException).log("Full RuntimeException");
        }
        ErrorResponse icebergErrorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(responseCode)).withType(runtimeException.getClass().getSimpleName()).withMessage(runtimeException.getMessage()).build();
        Response errorResp = Response.status((int)responseCode).entity((Object)icebergErrorResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
        LOGGER.debug("Mapped exception to errorResp: {}", (Object)errorResp);
        return errorResp;
    }

    public static boolean containsAnyAccessDeniedHint(String message) {
        String messageLower = message.toLowerCase(Locale.ENGLISH);
        return ACCESS_DENIED_HINTS.stream().anyMatch(messageLower::contains);
    }

    public static boolean isStorageProviderRetryableException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t.getMessage() != null && IcebergExceptionMapper.containsAnyAccessDeniedHint(t.getMessage())) {
            return false;
        }
        Throwable throwable = t;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BaseServiceException.class, SdkException.class, HttpResponseException.class}, (Object)throwable2, n)) {
            case 0 -> {
                BaseServiceException bse = (BaseServiceException)throwable2;
                yield bse.isRetryable();
            }
            case 1 -> {
                SdkException se = (SdkException)throwable2;
                yield se.retryable();
            }
            case 2 -> {
                HttpResponseException hre = (HttpResponseException)throwable2;
                yield RETRYABLE_AZURE_HTTP_CODES.contains(IcebergExceptionMapper.extractHttpCodeFromCloudException((Throwable)hre));
            }
            default -> true;
        };
    }

    @VisibleForTesting
    public static Collection<String> getAccessDeniedHints() {
        return ImmutableSet.copyOf(ACCESS_DENIED_HINTS);
    }

    static int mapExceptionToResponseCode(RuntimeException rex) {
        for (Throwable t : Throwables.getCausalChain((Throwable)rex)) {
            Optional<Integer> code = IcebergExceptionMapper.mapCloudExceptionToResponseCode(t);
            if (!code.isPresent()) continue;
            return code.get();
        }
        RuntimeException runtimeException = rex;
        Objects.requireNonNull(runtimeException);
        RuntimeException runtimeException2 = runtimeException;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NoSuchNamespaceException.class, NoSuchIcebergTableException.class, NoSuchTableException.class, NoSuchViewException.class, NotFoundException.class, FileIOUnknownHostException.class, AlreadyExistsException.class, CommitFailedException.class, UnprocessableEntityException.class, CherrypickAncestorCommitException.class, CommitStateUnknownException.class, DuplicateWAPCommitException.class, ForbiddenException.class, jakarta.ws.rs.ForbiddenException.class, NotAuthorizedException.class, NamespaceNotEmptyException.class, ValidationException.class, ServiceUnavailableException.class, RuntimeIOException.class, ServiceFailureException.class, CleanableFailure.class, RESTException.class, IllegalArgumentException.class, UnsupportedOperationException.class, WebApplicationException.class, TimeoutException.class}, (Object)runtimeException2, n)) {
            case 0 -> {
                NoSuchNamespaceException e = (NoSuchNamespaceException)runtimeException2;
                yield Response.Status.NOT_FOUND.getStatusCode();
            }
            case 1 -> {
                NoSuchIcebergTableException e = (NoSuchIcebergTableException)runtimeException2;
                yield Response.Status.NOT_FOUND.getStatusCode();
            }
            case 2 -> {
                NoSuchTableException e = (NoSuchTableException)((Object)runtimeException2);
                yield Response.Status.NOT_FOUND.getStatusCode();
            }
            case 3 -> {
                NoSuchViewException e = (NoSuchViewException)((Object)runtimeException2);
                yield Response.Status.NOT_FOUND.getStatusCode();
            }
            case 4 -> {
                NotFoundException e = (NotFoundException)runtimeException2;
                yield Response.Status.NOT_FOUND.getStatusCode();
            }
            case 5 -> {
                FileIOUnknownHostException e = (FileIOUnknownHostException)runtimeException2;
                yield Response.Status.NOT_FOUND.getStatusCode();
            }
            case 6 -> {
                AlreadyExistsException e = (AlreadyExistsException)((Object)runtimeException2);
                yield Response.Status.CONFLICT.getStatusCode();
            }
            case 7 -> {
                CommitFailedException e = (CommitFailedException)((Object)runtimeException2);
                yield Response.Status.CONFLICT.getStatusCode();
            }
            case 8 -> {
                UnprocessableEntityException e = (UnprocessableEntityException)runtimeException2;
                yield 422;
            }
            case 9 -> {
                CherrypickAncestorCommitException e = (CherrypickAncestorCommitException)runtimeException2;
                yield Response.Status.BAD_REQUEST.getStatusCode();
            }
            case 10 -> {
                CommitStateUnknownException e = (CommitStateUnknownException)runtimeException2;
                yield Response.Status.BAD_REQUEST.getStatusCode();
            }
            case 11 -> {
                DuplicateWAPCommitException e = (DuplicateWAPCommitException)runtimeException2;
                yield Response.Status.BAD_REQUEST.getStatusCode();
            }
            case 12 -> {
                ForbiddenException e = (ForbiddenException)((Object)runtimeException2);
                yield Response.Status.FORBIDDEN.getStatusCode();
            }
            case 13 -> {
                jakarta.ws.rs.ForbiddenException e = (jakarta.ws.rs.ForbiddenException)runtimeException2;
                yield Response.Status.FORBIDDEN.getStatusCode();
            }
            case 14 -> {
                NotAuthorizedException e = (NotAuthorizedException)((Object)runtimeException2);
                yield Response.Status.UNAUTHORIZED.getStatusCode();
            }
            case 15 -> {
                NamespaceNotEmptyException e = (NamespaceNotEmptyException)runtimeException2;
                yield Response.Status.CONFLICT.getStatusCode();
            }
            case 16 -> {
                ValidationException e = (ValidationException)runtimeException2;
                yield Response.Status.BAD_REQUEST.getStatusCode();
            }
            case 17 -> {
                ServiceUnavailableException e = (ServiceUnavailableException)runtimeException2;
                yield Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
            }
            case 18 -> {
                RuntimeIOException e = (RuntimeIOException)runtimeException2;
                yield Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
            }
            case 19 -> {
                ServiceFailureException e = (ServiceFailureException)((Object)runtimeException2);
                yield Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
            }
            case 20 -> {
                CleanableFailure e = (CleanableFailure)runtimeException2;
                yield Response.Status.BAD_REQUEST.getStatusCode();
            }
            case 21 -> {
                RESTException e = (RESTException)runtimeException2;
                yield Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
            }
            case 22 -> {
                IllegalArgumentException e = (IllegalArgumentException)runtimeException2;
                yield Response.Status.BAD_REQUEST.getStatusCode();
            }
            case 23 -> {
                UnsupportedOperationException e = (UnsupportedOperationException)runtimeException2;
                yield Response.Status.NOT_ACCEPTABLE.getStatusCode();
            }
            case 24 -> {
                WebApplicationException e = (WebApplicationException)runtimeException2;
                yield e.getResponse().getStatus();
            }
            case 25 -> {
                TimeoutException e = (TimeoutException)runtimeException2;
                yield Response.Status.REQUEST_TIMEOUT.getStatusCode();
            }
            default -> Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        };
    }

    public static int extractHttpCodeFromCloudException(Throwable t) {
        Throwable throwable = t;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{S3Exception.class, HttpResponseException.class, StorageException.class}, (Object)throwable2, n)) {
            case 0 -> {
                S3Exception s3e = (S3Exception)throwable2;
                yield s3e.statusCode();
            }
            case 1 -> {
                HttpResponseException hre = (HttpResponseException)throwable2;
                yield hre.getResponse().getStatusCode();
            }
            case 2 -> {
                StorageException se = (StorageException)throwable2;
                yield se.getCode();
            }
            default -> -1;
        };
    }

    static Optional<Integer> mapCloudExceptionToResponseCode(Throwable t) {
        if (!(t instanceof S3Exception || t instanceof AzureException || t instanceof StorageException)) {
            return Optional.empty();
        }
        if (IcebergExceptionMapper.containsAnyAccessDeniedHint(t.getMessage())) {
            return Optional.of(Response.Status.FORBIDDEN.getStatusCode());
        }
        int httpCode = IcebergExceptionMapper.extractHttpCodeFromCloudException(t);
        Response.Status httpStatus = Response.Status.fromStatusCode((int)httpCode);
        Response.Status.Family httpFamily = Response.Status.Family.familyOf((int)httpCode);
        if (httpStatus == Response.Status.NOT_FOUND) {
            return Optional.of(Response.Status.BAD_REQUEST.getStatusCode());
        }
        if (httpStatus == Response.Status.UNAUTHORIZED) {
            return Optional.of(Response.Status.FORBIDDEN.getStatusCode());
        }
        if (httpStatus == Response.Status.BAD_REQUEST || httpStatus == Response.Status.FORBIDDEN || httpStatus == Response.Status.REQUEST_TIMEOUT || httpStatus == Response.Status.TOO_MANY_REQUESTS || httpStatus == Response.Status.GATEWAY_TIMEOUT) {
            return Optional.of(httpCode);
        }
        if (httpFamily == Response.Status.Family.REDIRECTION) {
            return Optional.of(422);
        }
        if (httpFamily == Response.Status.Family.SERVER_ERROR) {
            return Optional.of(Response.Status.BAD_GATEWAY.getStatusCode());
        }
        return Optional.of(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    @VisibleForTesting
    Logger getLoggerForExceptionLogging() {
        return LOGGER;
    }
}

