/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.secrets;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.polaris.core.DigestUtils;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.secrets.SecretReference;
import org.apache.polaris.core.secrets.UserSecretsManager;

public class UnsafeInMemorySecretsManager
implements UserSecretsManager {
    private final Map<String, String> rawSecretStore = new ConcurrentHashMap<String, String>();
    private final SecureRandom rand = new SecureRandom();
    private static final String CIPHERTEXT_HASH = "ciphertext-hash";
    private static final String ENCRYPTION_KEY = "encryption-key";
    public static final String SECRET_MANAGER_TYPE = "unsafe-in-memory";

    @Override
    @Nonnull
    public SecretReference writeSecret(@Nonnull String secret, @Nonnull PolarisEntityCore forEntity) {
        String typeSpecificIdentifier;
        String secretUrn;
        String existingSecret;
        byte[] secretBytes = secret.getBytes(StandardCharsets.UTF_8);
        byte[] oneTimeKey = new byte[secretBytes.length];
        byte[] cipherTextBytes = new byte[secretBytes.length];
        this.rand.nextBytes(oneTimeKey);
        for (int i = 0; i < cipherTextBytes.length; ++i) {
            cipherTextBytes[i] = (byte)(secretBytes[i] ^ oneTimeKey[i]);
        }
        String encryptedSecretCipherTextBase64 = Base64.getEncoder().encodeToString(cipherTextBytes);
        String encryptedSecretKeyBase64 = Base64.getEncoder().encodeToString(oneTimeKey);
        int secretOrdinal = 0;
        while ((existingSecret = this.rawSecretStore.putIfAbsent(secretUrn = this.buildUrn(SECRET_MANAGER_TYPE, typeSpecificIdentifier = forEntity.getId() + ":" + secretOrdinal), encryptedSecretCipherTextBase64)) != null) {
            ++secretOrdinal;
        }
        HashMap<String, String> referencePayload = new HashMap<String, String>();
        referencePayload.put(CIPHERTEXT_HASH, DigestUtils.sha256Hex(encryptedSecretCipherTextBase64));
        referencePayload.put(ENCRYPTION_KEY, encryptedSecretKeyBase64);
        SecretReference secretReference = new SecretReference(secretUrn, referencePayload);
        return secretReference;
    }

    @Override
    @Nonnull
    public String readSecret(@Nonnull SecretReference secretReference) {
        String secretManagerType = secretReference.getSecretManagerType();
        Preconditions.checkState((boolean)secretManagerType.equals(SECRET_MANAGER_TYPE), (Object)("Invalid secret manager type, expected: unsafe-in-memory got: " + secretManagerType));
        String encryptedSecretCipherTextBase64 = this.rawSecretStore.get(secretReference.getUrn());
        if (encryptedSecretCipherTextBase64 == null) {
            return null;
        }
        String encryptedSecretKeyBase64 = secretReference.getReferencePayload().get(ENCRYPTION_KEY);
        String expecteCipherTextBase64Hash = secretReference.getReferencePayload().get(CIPHERTEXT_HASH);
        String retrievedCipherTextBase64Hash = DigestUtils.sha256Hex(encryptedSecretCipherTextBase64);
        if (!Objects.equals(retrievedCipherTextBase64Hash, expecteCipherTextBase64Hash)) {
            throw new IllegalArgumentException(String.format("Ciphertext hash mismatch for URN %s; expected %s got %s", secretReference.getUrn(), expecteCipherTextBase64Hash, retrievedCipherTextBase64Hash));
        }
        byte[] cipherTextBytes = Base64.getDecoder().decode(encryptedSecretCipherTextBase64);
        byte[] oneTimeKey = Base64.getDecoder().decode(encryptedSecretKeyBase64);
        byte[] secretBytes = new byte[cipherTextBytes.length];
        for (int i = 0; i < cipherTextBytes.length; ++i) {
            secretBytes[i] = (byte)(cipherTextBytes[i] ^ oneTimeKey[i]);
        }
        return new String(secretBytes, StandardCharsets.UTF_8);
    }

    @Override
    public void deleteSecret(@Nonnull SecretReference secretReference) {
        this.rawSecretStore.remove(secretReference.getUrn());
    }
}

