/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.immutables.value.Generated;

@Generated(from="OpaAuthorizationConfig.HttpConfig", generator="Immutables")
public final class ImmutableHttpConfig
implements OpaAuthorizationConfig.HttpConfig {
    private final Duration timeout;
    private final boolean verifySsl;
    private final Path trustStorePath;
    private final String trustStorePassword;
    private transient int hashCode;

    private ImmutableHttpConfig(Duration timeout, boolean verifySsl, Path trustStorePath, String trustStorePassword) {
        this.timeout = timeout;
        this.verifySsl = verifySsl;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public Duration timeout() {
        return this.timeout;
    }

    @Override
    public boolean verifySsl() {
        return this.verifySsl;
    }

    @Override
    public Optional<Path> trustStorePath() {
        return Optional.ofNullable(this.trustStorePath);
    }

    @Override
    public Optional<String> trustStorePassword() {
        return Optional.ofNullable(this.trustStorePassword);
    }

    public final ImmutableHttpConfig withTimeout(Duration value) {
        if (this.timeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "timeout");
        return new ImmutableHttpConfig(newValue, this.verifySsl, this.trustStorePath, this.trustStorePassword);
    }

    public final ImmutableHttpConfig withVerifySsl(boolean value) {
        if (this.verifySsl == value) {
            return this;
        }
        return new ImmutableHttpConfig(this.timeout, value, this.trustStorePath, this.trustStorePassword);
    }

    public final ImmutableHttpConfig withTrustStorePath(Path value) {
        Path newValue = Objects.requireNonNull(value, "trustStorePath");
        if (this.trustStorePath == newValue) {
            return this;
        }
        return new ImmutableHttpConfig(this.timeout, this.verifySsl, newValue, this.trustStorePassword);
    }

    public final ImmutableHttpConfig withTrustStorePath(Optional<? extends Path> optional) {
        Path value = optional.orElse(null);
        if (this.trustStorePath == value) {
            return this;
        }
        return new ImmutableHttpConfig(this.timeout, this.verifySsl, value, this.trustStorePassword);
    }

    public final ImmutableHttpConfig withTrustStorePassword(String value) {
        String newValue = Objects.requireNonNull(value, "trustStorePassword");
        if (Objects.equals(this.trustStorePassword, newValue)) {
            return this;
        }
        return new ImmutableHttpConfig(this.timeout, this.verifySsl, this.trustStorePath, newValue);
    }

    public final ImmutableHttpConfig withTrustStorePassword(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.trustStorePassword, value)) {
            return this;
        }
        return new ImmutableHttpConfig(this.timeout, this.verifySsl, this.trustStorePath, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpConfig && this.equalsByValue((ImmutableHttpConfig)another);
    }

    private boolean equalsByValue(ImmutableHttpConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.timeout.equals(another.timeout) && this.verifySsl == another.verifySsl && Objects.equals(this.trustStorePath, another.trustStorePath) && Objects.equals(this.trustStorePassword, another.trustStorePassword);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.timeout.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.verifySsl);
        h += (h << 5) + Objects.hashCode(this.trustStorePath);
        h += (h << 5) + Objects.hashCode(this.trustStorePassword);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HttpConfig").omitNullValues().add("timeout", (Object)this.timeout).add("verifySsl", this.verifySsl).add("trustStorePath", (Object)this.trustStorePath).add("trustStorePassword", (Object)this.trustStorePassword).toString();
    }

    public static ImmutableHttpConfig copyOf(OpaAuthorizationConfig.HttpConfig instance) {
        if (instance instanceof ImmutableHttpConfig) {
            return (ImmutableHttpConfig)instance;
        }
        return ImmutableHttpConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableHttpConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OpaAuthorizationConfig.HttpConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TIMEOUT = 1L;
        private static final long INIT_BIT_VERIFY_SSL = 2L;
        private long initBits = 3L;
        private Duration timeout;
        private boolean verifySsl;
        private Path trustStorePath;
        private String trustStorePassword;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OpaAuthorizationConfig.HttpConfig instance) {
            Optional<String> trustStorePasswordOptional;
            Objects.requireNonNull(instance, "instance");
            this.timeout(instance.timeout());
            this.verifySsl(instance.verifySsl());
            Optional<Path> trustStorePathOptional = instance.trustStorePath();
            if (trustStorePathOptional.isPresent()) {
                this.trustStorePath(trustStorePathOptional);
            }
            if ((trustStorePasswordOptional = instance.trustStorePassword()).isPresent()) {
                this.trustStorePassword(trustStorePasswordOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder verifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trustStorePath(Path trustStorePath) {
            this.trustStorePath = Objects.requireNonNull(trustStorePath, "trustStorePath");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trustStorePath(Optional<? extends Path> trustStorePath) {
            this.trustStorePath = trustStorePath.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Objects.requireNonNull(trustStorePassword, "trustStorePassword");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trustStorePassword(Optional<String> trustStorePassword) {
            this.trustStorePassword = trustStorePassword.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.timeout = null;
            this.verifySsl = false;
            this.trustStorePath = null;
            this.trustStorePassword = null;
            return this;
        }

        public ImmutableHttpConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHttpConfig(this.timeout, this.verifySsl, this.trustStorePath, this.trustStorePassword);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timeout");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("verifySsl");
            }
            return "Cannot build HttpConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

