/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.util.Iterator;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IInternalMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.DeviceInfo;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class MNodeUtils {
    public static <N extends IMNode<N>> boolean setToEntity(IMNode<N> node) {
        IInternalMNode internalMNode = node.getAsInternalMNode();
        if (!internalMNode.isDevice()) {
            internalMNode.setDeviceInfo(new DeviceInfo());
            return true;
        }
        return false;
    }

    public static <N extends IMNode<N>> boolean setToInternal(IDeviceMNode<N> entityMNode) {
        IInternalMNode internalMNode = entityMNode.getAsInternalMNode();
        if (internalMNode.isDevice()) {
            internalMNode.setDeviceInfo(null);
            return true;
        }
        return false;
    }

    public static <N extends IMNode<N>> N getChild(Template template, String name, IMNodeFactory<N> nodeFactor) {
        IMeasurementSchema schema = template.getSchema(name);
        return (N)(schema == null ? null : nodeFactor.createMeasurementMNode(null, name, template.getSchema(name), null).getAsMNode());
    }

    public static <N extends IMNode<N>> Iterator<N> getChildren(final Template template, final IMNodeFactory<N> nodeFactor) {
        return new Iterator<N>(){
            private final Iterator<IMeasurementSchema> schemas;
            {
                this.schemas = template.getSchemaMap().values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.schemas.hasNext();
            }

            @Override
            public N next() {
                IMeasurementSchema schema = this.schemas.next();
                return nodeFactor.createMeasurementMNode(null, schema.getMeasurementId(), schema, null).getAsMNode();
            }
        };
    }
}

