/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFExecutableManager
extends ExecutableManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFExecutableManager.class);
    private static UDFExecutableManager INSTANCE = null;

    private UDFExecutableManager(String temporaryLibRoot, String udfLibRoot) {
        super(temporaryLibRoot, udfLibRoot);
    }

    public static synchronized UDFExecutableManager setupAndGetInstance(String temporaryLibRoot, String udfLibRoot) throws IOException {
        if (INSTANCE == null) {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(temporaryLibRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(udfLibRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(udfLibRoot + File.separator + "install");
            INSTANCE = new UDFExecutableManager(temporaryLibRoot, udfLibRoot);
        }
        return INSTANCE;
    }

    public static UDFExecutableManager getInstance() {
        return INSTANCE;
    }
}

