/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.thrift.handler;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class RPCServiceThriftHandlerMetrics
implements IMetricSet {
    private AtomicLong thriftConnectionNumber;

    public RPCServiceThriftHandlerMetrics(AtomicLong thriftConnectionNumber) {
        this.thriftConnectionNumber = thriftConnectionNumber;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.THRIFT_CONNECTIONS.toString(), MetricLevel.CORE, (Object)this.thriftConnectionNumber, AtomicLong::get, new String[]{Tag.NAME.toString(), "ClientRPC"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.THRIFT_CONNECTIONS.toString(), new String[]{Tag.NAME.toString(), "ClientRPC"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RPCServiceThriftHandlerMetrics that = (RPCServiceThriftHandlerMetrics)o;
        return Objects.equals(this.thriftConnectionNumber, that.thriftConnectionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.thriftConnectionNumber);
    }
}

