/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Pair;

public abstract class AbstractSeriesAggregationScanOperator
extends AbstractDataSourceOperator {
    protected final boolean ascending;
    protected final boolean isGroupByQuery;
    protected int subSensorSize;
    protected TsBlock inputTsBlock;
    protected final ITimeRangeIterator timeRangeIterator;
    protected TimeRange curTimeRange;
    protected final List<Aggregator> aggregators;
    protected boolean finished = false;
    protected final boolean outputEndTime;
    private final long cachedRawDataSize;
    private long leftRuntimeOfOneNextCall;
    private final boolean canUseStatistics;

    protected AbstractSeriesAggregationScanOperator(PlanNodeId sourceId, OperatorContext context, SeriesScanUtil seriesScanUtil, int subSensorSize, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, boolean ascending, boolean outputEndTime, GroupByTimeParameter groupByTimeParameter, long maxReturnSize, long cachedRawDataSize, boolean canUseStatistics) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.ascending = ascending;
        this.isGroupByQuery = groupByTimeParameter != null;
        this.seriesScanUtil = seriesScanUtil;
        this.subSensorSize = subSensorSize;
        this.aggregators = aggregators;
        this.timeRangeIterator = timeRangeIterator;
        this.cachedRawDataSize = cachedRawDataSize;
        this.maxReturnSize = maxReturnSize;
        this.outputEndTime = outputEndTime;
        this.canUseStatistics = canUseStatistics;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.cachedRawDataSize + this.maxReturnSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.isGroupByQuery ? this.cachedRawDataSize : 0L;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() throws Exception {
        long start = System.nanoTime();
        long maxRuntime = this.leftRuntimeOfOneNextCall = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        while (System.nanoTime() - start < maxRuntime && (this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange()) && !this.resultTsBlockBuilder.isFull()) {
            Optional<Boolean> b;
            if (this.curTimeRange == null) {
                this.curTimeRange = this.timeRangeIterator.nextTimeRange();
                for (Aggregator aggregator : this.aggregators) {
                    aggregator.reset();
                }
            }
            if (!(b = this.calculateAggregationResultForCurrentTimeRange()).isPresent() || !b.get().booleanValue()) continue;
            this.curTimeRange = null;
        }
        if (this.resultTsBlockBuilder.getPositionCount() > 0) {
            TsBlock resultTsBlock = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (!this.finished) {
            this.finished = !this.hasNextWithTimer();
        }
        return this.finished;
    }

    protected Optional<Boolean> calculateAggregationResultForCurrentTimeRange() {
        try {
            Optional<Boolean> b;
            if (this.calcFromCachedData()) {
                this.updateResultTsBlock();
                return Optional.of(true);
            }
            if (this.readAndCalcFromPage()) {
                this.updateResultTsBlock();
                return Optional.of(true);
            }
            if (!this.seriesScanUtil.hasNextPage() && this.readAndCalcFromChunk()) {
                this.updateResultTsBlock();
                return Optional.of(true);
            }
            if (!this.seriesScanUtil.hasNextPage()) {
                b = this.seriesScanUtil.hasNextChunk();
                if (!b.isPresent()) {
                    return b;
                }
                if (!b.get().booleanValue() && this.readAndCalcFromFile()) {
                    this.updateResultTsBlock();
                    return Optional.of(true);
                }
            }
            if (this.seriesScanUtil.hasNextPage()) {
                return Optional.of(false);
            }
            b = this.seriesScanUtil.hasNextChunk();
            if (!b.isPresent()) {
                return b;
            }
            if (b.get().booleanValue()) {
                return Optional.of(false);
            }
            b = this.seriesScanUtil.hasNextFile();
            if (!b.isPresent()) {
                return b;
            }
            if (b.get().booleanValue()) {
                return Optional.of(false);
            }
            this.updateResultTsBlock();
            return Optional.of(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while scanning the file", e);
        }
    }

    protected void updateResultTsBlock() {
        if (!this.outputEndTime) {
            AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime());
        } else {
            AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime(), this.curTimeRange.getMax());
        }
    }

    protected boolean calcFromCachedData() {
        return this.calcFromRawData(this.inputTsBlock);
    }

    private boolean calcFromRawData(TsBlock tsBlock) {
        Pair<Boolean, TsBlock> calcResult = AggregationUtil.calculateAggregationFromRawData(tsBlock, this.aggregators, this.curTimeRange, this.ascending);
        this.inputTsBlock = (TsBlock)calcResult.getRight();
        return (Boolean)calcResult.getLeft();
    }

    protected void calcFromStatistics(Statistics timeStatistics, Statistics[] valueStatistics) {
        for (Aggregator aggregator : this.aggregators) {
            if (aggregator.hasFinalResult()) continue;
            aggregator.processStatistics(timeStatistics, valueStatistics);
        }
    }

    protected boolean readAndCalcFromFile() throws IOException {
        long start = System.nanoTime();
        while (System.nanoTime() - start < this.leftRuntimeOfOneNextCall) {
            Optional<Boolean> b = this.seriesScanUtil.hasNextFile();
            if (!b.isPresent()) continue;
            if (!b.get().booleanValue()) break;
            if (this.canUseStatistics && this.seriesScanUtil.canUseCurrentFileStatistics()) {
                Statistics fileTimeStatistics = this.seriesScanUtil.currentFileTimeStatistics();
                if (fileTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentFile();
                    continue;
                }
                if (this.curTimeRange.contains(fileTimeStatistics.getStartTime(), fileTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentFileStatistics(i);
                    }
                    this.calcFromStatistics(fileTimeStatistics, statisticsList);
                    this.seriesScanUtil.skipCurrentFile();
                    if (!AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromChunk()) continue;
            return true;
        }
        return false;
    }

    protected boolean readAndCalcFromChunk() throws IOException {
        long start = System.nanoTime();
        while (System.nanoTime() - start < this.leftRuntimeOfOneNextCall) {
            Optional<Boolean> b = this.seriesScanUtil.hasNextChunk();
            if (!b.isPresent()) continue;
            if (!b.get().booleanValue()) break;
            if (this.canUseStatistics && this.seriesScanUtil.canUseCurrentChunkStatistics()) {
                Statistics chunkTimeStatistics = this.seriesScanUtil.currentChunkTimeStatistics();
                if (chunkTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentChunk();
                    continue;
                }
                if (this.curTimeRange.contains(chunkTimeStatistics.getStartTime(), chunkTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentChunkStatistics(i);
                    }
                    this.calcFromStatistics(chunkTimeStatistics, statisticsList);
                    this.seriesScanUtil.skipCurrentChunk();
                    if (!AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromPage()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readAndCalcFromPage() throws IOException {
        long start = System.nanoTime();
        try {
            while (System.nanoTime() - start < this.leftRuntimeOfOneNextCall && this.seriesScanUtil.hasNextPage()) {
                TsBlock tsBlock;
                if (this.canUseStatistics && this.seriesScanUtil.canUseCurrentPageStatistics()) {
                    Statistics pageTimeStatistics = this.seriesScanUtil.currentPageTimeStatistics();
                    if (pageTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                        if (this.ascending) {
                            boolean bl = true;
                            return bl;
                        }
                        this.seriesScanUtil.skipCurrentPage();
                        continue;
                    }
                    if (this.curTimeRange.contains(pageTimeStatistics.getStartTime(), pageTimeStatistics.getEndTime())) {
                        Statistics[] statisticsList = new Statistics[this.subSensorSize];
                        for (int i = 0; i < this.subSensorSize; ++i) {
                            statisticsList[i] = this.seriesScanUtil.currentPageStatistics(i);
                        }
                        this.calcFromStatistics(pageTimeStatistics, statisticsList);
                        this.seriesScanUtil.skipCurrentPage();
                        if (!AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || this.isGroupByQuery) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if ((tsBlock = this.seriesScanUtil.nextPage()) == null || tsBlock.isEmpty()) continue;
                if (!this.calcFromRawData(tsBlock)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.leftRuntimeOfOneNextCall -= System.nanoTime() - start;
        }
    }

    @Override
    protected List<TSDataType> getResultDataTypes() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        if (this.outputEndTime) {
            dataTypes.add(TSDataType.INT64);
        }
        for (Aggregator aggregator : this.aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        return dataTypes;
    }
}

