/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MaybeSender;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.james.jspf.impl.SPF;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPFHandler
implements JamesMessageHook,
MailHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPFHandler.class);
    private static final Logger FALLBACK_LOG = LoggerFactory.getLogger(SPFHandler.class);
    private final Logger serviceLog = FALLBACK_LOG;
    private static final ProtocolSession.AttachmentKey<Boolean> SPF_BLOCKLISTED = ProtocolSession.AttachmentKey.of((String)"SPF_BLOCKLISTED", Boolean.class);
    private static final ProtocolSession.AttachmentKey<String> SPF_DETAIL = ProtocolSession.AttachmentKey.of((String)"SPF_DETAIL", String.class);
    private static final ProtocolSession.AttachmentKey<Boolean> SPF_TEMPBLOCKLISTED = ProtocolSession.AttachmentKey.of((String)"SPF_TEMPBLOCKLISTED", Boolean.class);
    private static final ProtocolSession.AttachmentKey<String> SPF_HEADER = ProtocolSession.AttachmentKey.of((String)"SPF_HEADER", String.class);
    private static final AttributeName SPF_HEADER_MAIL_ATTRIBUTE_NAME = AttributeName.of((String)"org.apache.james.spf.header");
    private boolean blockSoftFail = false;
    private boolean blockPermError = true;
    private SPF spf = new DefaultSPF();

    public void setBlockSoftFail(boolean blockSoftFail) {
        this.blockSoftFail = blockSoftFail;
    }

    public void setBlockPermError(boolean blockPermError) {
        this.blockPermError = blockPermError;
    }

    @Inject
    public void setDNSService(DNSService dnsService) {
        this.spf = new SPF(dnsService);
    }

    private void doSPFCheck(SMTPSession session, MaybeSender sender) {
        Optional heloEhlo = session.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection);
        if (sender.isNullSender() || !heloEhlo.isPresent()) {
            LOGGER.info("No Sender or HELO/EHLO present");
        } else {
            String ip = session.getRemoteAddress().getAddress().getHostAddress();
            SPFResult result = this.spf.checkSPF(ip, sender.asString(), (String)heloEhlo.get());
            String spfResult = result.getResult();
            Object explanation = "Blocked - see: " + result.getExplanation();
            session.setAttachment(SPF_HEADER, (Object)result.getHeaderText(), ProtocolSession.State.Transaction);
            LOGGER.info("Result for {} - {} - {} = {}", new Object[]{ip, sender.asString(), heloEhlo, spfResult});
            if (spfResult.equals("fail") || spfResult.equals("softfail") && this.blockSoftFail || spfResult.equals("permerror") && this.blockPermError) {
                if (spfResult.equals("permerror")) {
                    explanation = "Block caused by an invalid SPF record";
                }
                session.setAttachment(SPF_DETAIL, explanation, ProtocolSession.State.Transaction);
                session.setAttachment(SPF_BLOCKLISTED, (Object)true, ProtocolSession.State.Transaction);
            } else if (spfResult.equals("temperror")) {
                session.setAttachment(SPF_TEMPBLOCKLISTED, (Object)true, ProtocolSession.State.Transaction);
            }
        }
    }

    public HookResult doMail(SMTPSession session, MaybeSender sender) {
        if (!session.isRelayingAllowed()) {
            this.doSPFCheck(session, sender);
            if (session.getAttachment(SPF_BLOCKLISTED, ProtocolSession.State.Transaction).isPresent()) {
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.1") + " " + String.valueOf(session.getAttachment(SPF_TEMPBLOCKLISTED, ProtocolSession.State.Transaction).orElse(false))).build();
            }
            if (session.getAttachment(SPF_TEMPBLOCKLISTED, ProtocolSession.State.Transaction).isPresent()) {
                return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus((int)4, (String)"4.3") + " Temporarily rejected: Problem on SPF lookup").build();
            }
        }
        return HookResult.DECLINED;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        session.getAttachment(SPF_HEADER, ProtocolSession.State.Transaction).ifPresent(s -> mail.setAttribute(new Attribute(SPF_HEADER_MAIL_ATTRIBUTE_NAME, AttributeValue.of((String)s))));
        return null;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setBlockSoftFail(config.getBoolean("blockSoftFail", false));
        this.setBlockPermError(config.getBoolean("blockPermError", true));
    }
}

