/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.QuerySolutionBase;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.FmtUtils;

public class QuerySolutionMap
extends QuerySolutionBase {
    private Map<String, RDFNode> map = new HashMap<String, RDFNode>();

    public void add(String name, RDFNode node) {
        this.map.put(Var.canonical(name), node);
    }

    @Override
    protected RDFNode _get(String varName) {
        return this.map.get(varName);
    }

    @Override
    protected boolean _contains(String varName) {
        return this.map.containsKey(varName);
    }

    @Override
    public Iterator<String> varNames() {
        return this.map.keySet().iterator();
    }

    public void addAll(QuerySolutionMap other) {
        this.map.putAll(other.map);
    }

    public Map<String, RDFNode> asMap() {
        return Map.copyOf(this.map);
    }

    public void addAll(QuerySolution other) {
        Iterator<String> iter = other.varNames();
        while (iter.hasNext()) {
            String vName = iter.next();
            RDFNode rdfNode = other.get(vName);
            this.map.put(vName, rdfNode);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        Object tmp = "";
        String sep = "";
        Iterator<String> iter = this.varNames();
        while (iter.hasNext()) {
            String varName = iter.next();
            RDFNode n = this._get(varName);
            String nStr = FmtUtils.stringForRDFNode(n);
            tmp = (String)tmp + sep + "( ?" + varName + ", " + nStr + " )";
        }
        return tmp;
    }
}

