/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class BeanTraverseSession
extends BeanSession {
    private final BeanTraverseContext ctx;
    private final LinkedList<StackElement> stack = new LinkedList();
    private final Map<Object, Object> set;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    private boolean isBottom;
    public int indent;
    private int depth;

    protected BeanTraverseSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.indent = builder.initialDepth;
        this.set = this.isDetectRecursions() || this.isDebug() ? new IdentityHashMap<Object, Object>() : CollectionUtils.mape();
    }

    public final int getInitialDepth() {
        return this.ctx.getInitialDepth();
    }

    public final JsonMap getLastLocation() {
        Predicate<Object> nn = Utils::nn;
        Predicate<Collection> nec = Utils::ne;
        return JsonMap.create().appendIf(nn, "currentClass", this.currentClass).appendIf(nn, "currentProperty", this.currentProperty).appendIf(nec, "stack", this.stack);
    }

    public final int getMaxDepth() {
        return this.ctx.getMaxDepth();
    }

    public final boolean isDetectRecursions() {
        return this.ctx.isDetectRecursions();
    }

    public final boolean isIgnoreRecursions() {
        return this.ctx.isIgnoreRecursions();
    }

    protected final ClassMeta<?> getOptionalType(ClassMeta<?> cm) {
        if (cm.isOptional()) {
            return this.getOptionalType(cm.getElementType());
        }
        return cm;
    }

    protected final Object getOptionalValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Optional) {
            Optional o2 = (Optional)o;
            return this.getOptionalValue(o2.orElse(null));
        }
        return o;
    }

    protected String getStack(boolean full) {
        StringBuilder sb = new StringBuilder();
        this.stack.forEach(x -> {
            if (full) {
                sb.append("\n\t");
                for (int i = 1; i < x.depth; ++i) {
                    sb.append("  ");
                }
                if (x.depth > 0) {
                    sb.append("->");
                }
                sb.append(x.toString(false));
            } else {
                sb.append(" > ").append(x.toString(true));
            }
        });
        return sb.toString();
    }

    protected static final boolean isOptional(ClassMeta<?> cm) {
        return Utils.nn(cm) && cm.isOptional();
    }

    protected final boolean isRoot() {
        return this.depth == 1;
    }

    protected void onError(Throwable t, String msg, Object ... args) {
        super.addWarning(msg, args);
    }

    protected final void pop() {
        Object o;
        Object o2;
        --this.indent;
        --this.depth;
        if ((this.isDetectRecursions() || this.isDebug()) && !this.isBottom && (o2 = this.set.remove(o = this.stack.removeLast().o)) == null) {
            this.onError(null, "Couldn't remove object of type ''{0}'' on attribute ''{1}'' from object stack.", Utils.cn((Object)o), this.stack);
        }
        this.isBottom = false;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"indent", (Object)this.indent).a((Object)"depth", (Object)this.depth);
    }

    protected final ClassMeta<?> push(String attrName, Object o, ClassMeta<?> eType) throws BeanRecursionException {
        ClassMeta<?> cm;
        ++this.indent;
        ++this.depth;
        this.isBottom = true;
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ClassMeta<?> classMeta = Utils.nn(eType) && c == eType.inner() ? eType : (cm = o instanceof ClassMeta ? (ClassMeta<?>)((Object)o) : this.getClassMeta(c));
        if (cm.isCharSequence() || cm.isNumber() || cm.isBoolean()) {
            return cm;
        }
        if (this.depth > this.getMaxDepth()) {
            return null;
        }
        if (this.isDetectRecursions() || this.isDebug()) {
            if (this.willRecurse(attrName, o, cm)) {
                return null;
            }
            this.isBottom = false;
            this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
            this.set.put(o, o);
        }
        return cm;
    }

    protected final void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    protected final void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    protected final boolean willExceedDepth() {
        return this.depth >= this.getMaxDepth();
    }

    protected final boolean willRecurse(String attrName, Object o, ClassMeta<?> cm) throws BeanRecursionException {
        if (!this.isDetectRecursions() && !this.isDebug() || !this.set.containsKey(o)) {
            return false;
        }
        if (this.isIgnoreRecursions() && !this.isDebug()) {
            return true;
        }
        this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
        throw new BeanRecursionException("Recursion occurred, stack={0}", this.getStack(true));
    }

    public static abstract class Builder
    extends BeanSession.Builder {
        private BeanTraverseContext ctx;
        private int initialDepth;

        protected Builder(BeanTraverseContext ctx) {
            super(((BeanTraverseContext)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx)).getBeanContext());
            this.ctx = ctx;
            this.initialDepth = ctx.getInitialDepth();
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }

    private class StackElement {
        final int depth;
        final String name;
        final Object o;
        final ClassMeta<?> aType;

        StackElement(int depth, String name, Object o, ClassMeta<?> aType) {
            this.depth = depth;
            this.name = name;
            this.o = o;
            this.aType = aType;
        }

        String toString(boolean simple) {
            StringBuilder sb = new StringBuilder().append('[').append(this.depth).append(']').append(' ');
            sb.append(Utils.e((CharSequence)this.name) ? "<noname>" : this.name).append(':');
            sb.append(this.aType.toString(simple));
            if (this.aType != this.aType.getSerializedClassMeta(BeanTraverseSession.this)) {
                sb.append('/').append(this.aType.getSerializedClassMeta(BeanTraverseSession.this).toString(simple));
            }
            return sb.toString();
        }
    }
}

