/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class SwapAnnotation {
    public static final Swap DEFAULT = SwapAnnotation.create().build();

    public static Swap copy(Swap a, VarResolverSession r) {
        return SwapAnnotation.create().impl(a.impl()).mediaTypes(r.resolve(a.mediaTypes())).on(r.resolve(a.on())).onClass(a.onClass()).template(r.resolve(a.template())).value(a.value()).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return SwapAnnotation.create().on(on);
    }

    public static Builder create(String ... on) {
        return SwapAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMF {
        private String[] description = new String[0];
        private Class<?> impl = Void.TYPE;
        private Class<?> value = Void.TYPE;
        private String template = "";
        private String[] mediaTypes = new String[0];

        protected Builder() {
            super(Swap.class);
        }

        public Swap build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder impl(Class<?> value) {
            this.impl = value;
            return this;
        }

        public Builder mediaTypes(String ... value) {
            this.mediaTypes = value;
            return this;
        }

        public Builder template(String value) {
            this.template = value;
            return this;
        }

        public Builder value(Class<?> value) {
            this.value = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Swap {
        private final String[] description;
        private final Class<?> impl;
        private final Class<?> value;
        private final String template;
        private final String[] mediaTypes;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.impl = b.impl;
            this.mediaTypes = (String[])CollectionUtils.copyOf((java.lang.Object[])b.mediaTypes);
            this.template = b.template;
            this.value = b.value;
        }

        @Override
        public Class<?> impl() {
            return this.impl;
        }

        @Override
        public String[] mediaTypes() {
            return this.mediaTypes;
        }

        @Override
        public String template() {
            return this.template;
        }

        @Override
        public Class<?> value() {
            return this.value;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Swap[] value();
    }

    public static class Applier
    extends AnnotationApplier<Swap, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Swap.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Swap> ai, BeanContext.Builder b) {
            Swap a = (Swap)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(SwapAnnotation.copy(a, this.vr()));
        }
    }
}

