/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedBeanMeta;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlBeanMeta
extends ExtendedBeanMeta {
    private final Map<String, BeanPropertyMeta> attrs;
    private final Map<String, BeanPropertyMeta> elements;
    private final BeanPropertyMeta attrsProperty;
    private final Map<String, BeanPropertyMeta> collapsedProperties;
    private final BeanPropertyMeta contentProperty;
    private final XmlFormat contentFormat;

    public XmlBeanMeta(BeanMeta<?> beanMeta, XmlMetaProvider mp) {
        super(beanMeta);
        Class c = beanMeta.getClassMeta().inner();
        XmlBeanMetaBuilder b = new XmlBeanMetaBuilder(beanMeta, mp);
        this.attrs = CollectionUtils.u(b.attrs);
        this.elements = CollectionUtils.u(b.elements);
        this.attrsProperty = b.attrsProperty;
        this.collapsedProperties = CollectionUtils.u(b.collapsedProperties);
        this.contentProperty = b.contentProperty;
        this.contentFormat = b.contentFormat;
        if (Utils.nn((Object)this.contentProperty) || this.contentFormat == XmlFormat.VOID) {
            if (!this.elements.isEmpty()) {
                throw ThrowableUtils.bex((Class)c, (String)"{0} and ELEMENT properties found on the same bean.  These cannot be mixed.", (Object[])new Object[]{this.contentFormat});
            }
            if (!this.collapsedProperties.isEmpty()) {
                throw ThrowableUtils.bex((Class)c, (String)"{0} and COLLAPSED properties found on the same bean.  These cannot be mixed.", (Object[])new Object[]{this.contentFormat});
            }
        }
        if (!this.collapsedProperties.isEmpty() && !Collections.disjoint(this.elements.keySet(), this.collapsedProperties.keySet())) {
            throw ThrowableUtils.bex((Class)c, (String)"Child element name conflicts found with another property.", (Object[])new Object[0]);
        }
    }

    public Map<String, BeanPropertyMeta> getAttrProperties() {
        return this.attrs;
    }

    public XmlFormat getContentFormat() {
        return this.contentFormat;
    }

    public BeanPropertyMeta getContentProperty() {
        return this.contentProperty;
    }

    protected Set<String> getAttrPropertyNames() {
        return this.attrs.keySet();
    }

    protected BeanPropertyMeta getAttrsProperty() {
        return this.attrsProperty;
    }

    protected String getAttrsPropertyName() {
        return this.attrsProperty == null ? null : this.attrsProperty.getName();
    }

    protected Map<String, BeanPropertyMeta> getCollapsedProperties() {
        return this.collapsedProperties;
    }

    protected Set<String> getCollapsedPropertyNames() {
        return this.collapsedProperties.keySet();
    }

    protected String getContentPropertyName() {
        return this.contentProperty == null ? null : this.contentProperty.getName();
    }

    protected Map<String, BeanPropertyMeta> getElementProperties() {
        return this.elements;
    }

    protected Set<String> getElementPropertyNames() {
        return this.elements.keySet();
    }

    protected BeanPropertyMeta getPropertyMeta(String fieldName) {
        if (Utils.nn(this.collapsedProperties)) {
            BeanPropertyMeta bpm = this.collapsedProperties.get(fieldName);
            if (bpm == null) {
                bpm = this.collapsedProperties.get("*");
            }
            if (Utils.nn((Object)bpm)) {
                return bpm;
            }
        }
        return this.getBeanMeta().getPropertyMeta(fieldName);
    }

    private static class XmlBeanMetaBuilder {
        Map<String, BeanPropertyMeta> attrs = CollectionUtils.map();
        Map<String, BeanPropertyMeta> elements = CollectionUtils.map();
        Map<String, BeanPropertyMeta> collapsedProperties = CollectionUtils.map();
        BeanPropertyMeta attrsProperty;
        BeanPropertyMeta contentProperty;
        XmlFormat contentFormat = XmlFormat.DEFAULT;

        XmlBeanMetaBuilder(BeanMeta<?> beanMeta, XmlMetaProvider mp) {
            Class c = beanMeta.getClassMeta().inner();
            ClassMeta<?> ci = beanMeta.getClassMeta();
            Value defaultFormat = Value.empty();
            beanMeta.getClassMeta().getBeanContext().getAnnotationProvider().find(Xml.class, ci, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).forEach(x -> {
                XmlFormat xf = x.format();
                if (xf == XmlFormat.ATTRS) {
                    defaultFormat.set((Object)XmlFormat.ATTR);
                } else if (xf.isOneOf(XmlFormat.ELEMENTS, XmlFormat.DEFAULT)) {
                    defaultFormat.set((Object)XmlFormat.ELEMENT);
                } else if (xf == XmlFormat.VOID) {
                    this.contentFormat = XmlFormat.VOID;
                    defaultFormat.set((Object)XmlFormat.VOID);
                } else {
                    throw ThrowableUtils.bex((Class)c, (String)"Invalid format specified in @Xml annotation on bean: {0}.  Must be one of the following: DEFAULT,ATTRS,ELEMENTS,VOID", (Object[])new Object[]{x.format()});
                }
            });
            beanMeta.getProperties().values().forEach(p -> {
                XmlFormat xf = mp.getXmlBeanPropertyMeta((BeanPropertyMeta)p).getXmlFormat();
                ClassMeta<?> pcm = p.getClassMeta();
                if (xf == XmlFormat.ATTR) {
                    this.attrs.put(p.getName(), (BeanPropertyMeta)p);
                } else if (xf == XmlFormat.ELEMENT) {
                    this.elements.put(p.getName(), (BeanPropertyMeta)p);
                } else if (xf == XmlFormat.COLLAPSED) {
                    this.collapsedProperties.put(p.getName(), (BeanPropertyMeta)p);
                } else if (xf == XmlFormat.DEFAULT) {
                    if (defaultFormat.get() == XmlFormat.ATTR) {
                        this.attrs.put(p.getName(), (BeanPropertyMeta)p);
                    } else {
                        this.elements.put(p.getName(), (BeanPropertyMeta)p);
                    }
                } else if (xf == XmlFormat.ATTRS) {
                    if (Utils.nn((Object)this.attrsProperty)) {
                        throw ThrowableUtils.bex((Class)c, (String)"Multiple instances of ATTRS properties defined on class.  Only one property can be designated as such.", (Object[])new Object[0]);
                    }
                    if (!pcm.isMapOrBean()) {
                        throw ThrowableUtils.bex((Class)c, (String)"Invalid type for ATTRS property.  Only properties of type Map and bean can be used.", (Object[])new Object[0]);
                    }
                    this.attrsProperty = p;
                } else if (xf.isOneOf(XmlFormat.ELEMENTS, XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT)) {
                    if (xf.isOneOf(XmlFormat.ELEMENTS, XmlFormat.MIXED, XmlFormat.MIXED_PWS) && !pcm.isCollectionOrArray()) {
                        throw ThrowableUtils.bex((Class)c, (String)"Invalid type for {0} property.  Only properties of type Collection and array can be used.", (Object[])new Object[]{xf});
                    }
                    if (Utils.nn((Object)this.contentProperty)) {
                        if (xf == this.contentFormat) {
                            throw ThrowableUtils.bex((Class)c, (String)"Multiple instances of {0} properties defined on class.  Only one property can be designated as such.", (Object[])new Object[]{xf});
                        }
                        throw ThrowableUtils.bex((Class)c, (String)"{0} and {1} properties found on the same bean.  Only one property can be designated as such.", (Object[])new Object[]{this.contentFormat, xf});
                    }
                    this.contentProperty = p;
                    this.contentFormat = xf;
                }
                String n = mp.getXmlBeanPropertyMeta((BeanPropertyMeta)p).getChildName();
                if (Utils.nn((Object)n)) {
                    if (this.collapsedProperties.containsKey(n) && this.collapsedProperties.get(n) != p) {
                        throw ThrowableUtils.bex((Class)c, (String)"Multiple properties found with the child name ''{0}''.", (Object[])new Object[]{n});
                    }
                    this.collapsedProperties.put(n, (BeanPropertyMeta)p);
                }
            });
        }
    }
}

