/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.support.ResolverHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiComponentResolver
implements ComponentResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiComponentResolver.class);
    private final BundleContext bundleContext;

    public OsgiComponentResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Component componentReg = ResolverHelper.lookupComponentInRegistryWithFallback((CamelContext)context, (String)name);
        if (componentReg != null) {
            return componentReg;
        }
        return this.getComponent(name, context);
    }

    protected Component getComponent(String name, CamelContext context) throws Exception {
        LOG.trace("Finding Component: {}", (Object)name);
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(ComponentResolver.class.getName(), "(component=" + name + ")");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (!ComponentResolver.class.isAssignableFrom(service.getClass())) continue;
                    ComponentResolver resolver = (ComponentResolver)service;
                    return resolver.resolveComponent(name, context);
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

