/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json.impl;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.felix.cm.json.ConfigurationWriter;
import org.apache.felix.cm.json.impl.JsonSupport;
import org.apache.felix.cm.json.impl.TypeConverter;

public class ConfigurationWriterImpl
implements ConfigurationWriter,
ConfigurationWriter.Builder {
    private boolean closed = false;
    private JsonGenerator generator;
    private boolean closeGenerator;

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Writer already closed");
        }
        this.closed = true;
    }

    @Override
    public ConfigurationWriter build(Writer writer) {
        this.generator = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true)).createGenerator((Writer)new FilterWriter(writer){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        });
        this.closeGenerator = true;
        return this;
    }

    @Override
    public ConfigurationWriter build(JsonGenerator generator) {
        this.generator = generator;
        this.closeGenerator = false;
        return this;
    }

    @Override
    public void writeConfiguration(Dictionary<String, Object> properties) throws IOException {
        this.checkClosed();
        try {
            this.writeConfigurationInternal(properties);
            if (this.closeGenerator) {
                this.generator.close();
            }
        }
        catch (JsonException je) {
            throw new IOException(je.getMessage(), je);
        }
    }

    private void writeConfigurationInternal(Dictionary<String, Object> properties) throws IOException {
        this.generator.writeStartObject();
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Object value = properties.get(name);
            Map.Entry<String, JsonValue> entry = TypeConverter.convertObjectToTypedJsonValue(value);
            String key = "".equals(entry.getKey()) ? name : name.concat(":").concat(entry.getKey());
            this.generator.write(key, entry.getValue());
        }
        this.generator.writeEnd();
    }

    @Override
    public void writeConfigurationResource(ConfigurationResource resource) throws IOException {
        this.checkClosed();
        try {
            this.generator.writeStartObject();
            for (Map.Entry<String, Object> entry : resource.getProperties().entrySet()) {
                this.generator.write(entry.getKey(), JsonSupport.convertToJson(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : resource.getConfigurations().entrySet()) {
                this.generator.writeKey(entry.getKey());
                this.writeConfigurationInternal((Dictionary)entry.getValue());
            }
            this.generator.writeEnd();
            if (this.closeGenerator) {
                this.generator.close();
            }
        }
        catch (JsonException je) {
            throw new IOException(je.getMessage(), je);
        }
    }
}

