/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MavenPluginPrerequisitesChecker;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;

@Named
@Singleton
public class MavenPluginJavaPrerequisiteChecker
implements MavenPluginPrerequisitesChecker {
    private final VersionScheme versionScheme;

    @Inject
    public MavenPluginJavaPrerequisiteChecker(VersionScheme versionScheme) {
        this.versionScheme = versionScheme;
    }

    @Override
    public void accept(PluginDescriptor pluginDescriptor) {
        String currentJavaVersion;
        String requiredJavaVersion = pluginDescriptor.getRequiredJavaVersion();
        if (requiredJavaVersion != null && !requiredJavaVersion.isEmpty() && !this.matchesVersion(requiredJavaVersion, currentJavaVersion = System.getProperty("java.version"))) {
            throw new IllegalStateException("Required Java version " + requiredJavaVersion + " is not met by current version: " + currentJavaVersion);
        }
    }

    boolean matchesVersion(String requiredVersion, String currentVersion) {
        Version current;
        VersionConstraint constraint;
        try {
            constraint = this.versionScheme.parseVersionConstraint(requiredVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Invalid 'requiredJavaVersion' given in plugin descriptor", e);
        }
        try {
            current = this.versionScheme.parseVersion(currentVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("Could not parse current Java version", e);
        }
        if (constraint.getRange() == null) {
            return constraint.getVersion().compareTo((Object)current) <= 0;
        }
        return constraint.containsVersion(current);
    }
}

