/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class J2SEProjectUtil {
    private static final String MODULE_INFO_JAVA = "module-info.java";
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "run.classpath", "debug.classpath", "javac.test.classpath", "run.test.classpath", "debug.test.classpath", "endorsed.classpath", "javac.modulepath", "run.modulepath", "debug.modulepath", "javac.test.modulepath", "run.test.modulepath", "debug.test.modulepath"};
    private static final Logger LOG = Logger.getLogger(J2SEProjectUtil.class.getName());

    private J2SEProjectUtil() {
    }

    public static Object getEvaluatedProperty(Project p, String value) {
        if (value == null) {
            return null;
        }
        J2SEProject j2seprj = p.getLookup().lookup(J2SEProject.class);
        if (j2seprj != null) {
            return j2seprj.evaluator().evaluate(value);
        }
        return null;
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = FileUtil.urlForArchiveOrDir(root);
        if (url == null) {
            throw new IllegalArgumentException(root.getAbsolutePath());
        }
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public static String getBuildXmlName(J2SEProject project) {
        assert (project != null);
        String buildScriptPath = project.evaluator().getProperty("buildfile");
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    public static FileObject getBuildXml(J2SEProject project) {
        return project.getProjectDirectory().getFileObject(J2SEProjectUtil.getBuildXmlName(project));
    }

    public static boolean isCompileOnSaveSupported(J2SEProject project) {
        Parameters.notNull("project", project);
        Map<String, String> props = project.evaluator().getProperties();
        if (props == null) {
            LOG.warning("PropertyEvaluator mapping could not be computed (e.g. due to a circular definition)");
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                if (!e.getKey().startsWith("compile.on.save.unsupported") || e.getValue() == null || !Boolean.valueOf(e.getValue()).booleanValue()) continue;
                return false;
            }
        }
        return BuildArtifactMapper.isCompileOnSaveSupported();
    }

    public static boolean isCompileOnSaveEnabled(J2SEProject project) {
        String compileOnSaveProperty = project.evaluator().getProperty("compile.on.save");
        return compileOnSaveProperty != null && Boolean.valueOf(compileOnSaveProperty) != false && J2SEProjectUtil.isCompileOnSaveSupported(project);
    }

    public static boolean isTrue(String param) {
        return "true".equalsIgnoreCase(param) || "yes".equalsIgnoreCase(param) || "on".equalsIgnoreCase(param);
    }

    public static String ref(@NonNull String propertyName, boolean lastEntry) {
        return String.format("${%s}%s", propertyName, lastEntry ? "" : ":");
    }

    public static String[] getBreakableProperties(@NonNull J2SEProject project) {
        SourceRoots roots = project.getSourceRoots();
        String[] srcRootProps = roots.getRootProperties();
        roots = project.getTestSourceRoots();
        String[] testRootProps = roots.getRootProperties();
        String[] result = new String[BREAKABLE_PROPERTIES.length + srcRootProps.length + testRootProps.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, result, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(srcRootProps, 0, result, BREAKABLE_PROPERTIES.length, srcRootProps.length);
        System.arraycopy(testRootProps, 0, result, BREAKABLE_PROPERTIES.length + srcRootProps.length, testRootProps.length);
        return result;
    }

    public static boolean hasModuleInfo(@NonNull SourceRoots roots) {
        ClassPath scp = null;
        for (FileObject root : roots.getRoots()) {
            FileObject mInfo = J2SEProjectUtil.getModuleInfo(root);
            if (mInfo == null) continue;
            if (scp == null) {
                scp = ClassPath.getClassPath(root, "classpath/source");
            }
            if (!scp.contains(mInfo)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static File getModuleInfo(@NonNull File root) {
        return new File(root, MODULE_INFO_JAVA);
    }

    @CheckForNull
    public static FileObject getModuleInfo(@NonNull FileObject root) {
        return root.getFileObject(MODULE_INFO_JAVA);
    }
}

