/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.diff.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.diff.tree.ExclusionPattern.ExclusionType;

public class FilterPanel extends javax.swing.JPanel {
    public static final String ACTION_ACCEPT = "ACCEPT";
    public static final String ACTION_DISCARD = "DISCARD";

    private final List<ActionListener> actionListeners = new ArrayList<>();

    /**
     * Creates new form FilterPanel
     */
    @SuppressWarnings("LeakingThisInConstructor")
    public FilterPanel() {
        initComponents();
    }

    public void setPatterns(List<ExclusionPattern> patterns) {
        StringBuilder sb = new StringBuilder();
        for(ExclusionPattern ep: patterns) {
            sb.append(ep.getPattern());
            sb.append("\n");
        }
        this.patternText.setText(sb.toString());
    }

    public List<ExclusionPattern> getPatterns() {
        List<ExclusionPattern> result = new ArrayList<>();
        for (String line : patternText.getText().split("\n")) {
            if (line.trim().isEmpty()) {
                continue;
            }
            ExclusionPattern ep = new ExclusionPattern();
            ep.setType(ExclusionType.WILDCARD);
            ep.setPattern(line);
            result.add(ep);
        }
        return result;
    }

    public void setUpdateGlobalList(boolean value) {
        updateGlobalList.setSelected(value);
    }

    public boolean isUpdateGlobalList() {
        return updateGlobalList.isSelected();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        title = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        patternScroll = new javax.swing.JScrollPane();
        patternText = new javax.swing.JTextArea();
        buttonPanel = new javax.swing.JPanel();
        updateGlobalList = new javax.swing.JCheckBox();
        cancelButton = new javax.swing.JButton();
        acceptButton = new javax.swing.JButton();

        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(540, 400));
        setLayout(new java.awt.GridBagLayout());

        title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | java.awt.Font.BOLD));
        org.openide.awt.Mnemonics.setLocalizedText(title, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.title.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(title, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.jLabel1.text")); // NOI18N
        jLabel1.setAlignmentY(0.0F);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jLabel1, gridBagConstraints);

        patternText.setColumns(20);
        patternText.setLineWrap(true);
        patternText.setRows(5);
        patternText.setWrapStyleWord(true);
        patternScroll.setViewportView(patternText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(patternScroll, gridBagConstraints);

        java.awt.FlowLayout flowLayout1 = new java.awt.FlowLayout();
        flowLayout1.setAlignOnBaseline(true);
        buttonPanel.setLayout(flowLayout1);

        updateGlobalList.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(updateGlobalList, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.updateGlobalList.text")); // NOI18N
        buttonPanel.add(updateGlobalList);

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.cancelButton.text")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);

        org.openide.awt.Mnemonics.setLocalizedText(acceptButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.acceptButton.text")); // NOI18N
        acceptButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                acceptButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(acceptButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_TRAILING;
        add(buttonPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void acceptButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_acceptButtonActionPerformed
        ActionEvent ae = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, ACTION_ACCEPT);
        for(ActionListener al: actionListeners) {
            al.actionPerformed(ae);
        }
    }//GEN-LAST:event_acceptButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        ActionEvent ae = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, ACTION_DISCARD);
        for (ActionListener al : actionListeners) {
            al.actionPerformed(ae);
        }
    }//GEN-LAST:event_cancelButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton acceptButton;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane patternScroll;
    private javax.swing.JTextArea patternText;
    private javax.swing.JLabel title;
    private javax.swing.JCheckBox updateGlobalList;
    // End of variables declaration//GEN-END:variables
}
