/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.openjdk.project.customizer;

import java.awt.Component;
import java.util.EnumMap;
import java.util.Map;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.modules.java.openjdk.project.Settings;
import org.netbeans.modules.java.openjdk.project.Settings.RunBuild;
import org.netbeans.spi.project.ui.support.ProjectCustomizer.Category;
import org.netbeans.spi.project.ui.support.ProjectCustomizer.CompositeCategoryProvider;
import org.openide.util.Lookup;

/**
 *
 * @author lahvac
 */
public class TestCategory extends javax.swing.JPanel {

    /**
     * Creates new form TestCategory
     */
    public TestCategory(RunBuild runBuild, String jtregLocation) {
        initComponents();
        this.buildBeforeTest.getModel().setSelectedItem(runBuild);
        this.jtregLocation.setText(jtregLocation);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT
     * modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buildBeforeTestLabel = new javax.swing.JLabel();
        buildBeforeTest = new javax.swing.JComboBox<>();
        jLabel1 = new javax.swing.JLabel();
        jtregLocation = new javax.swing.JTextField();

        buildBeforeTestLabel.setLabelFor(buildBeforeTest);
        org.openide.awt.Mnemonics.setLocalizedText(buildBeforeTestLabel, org.openide.util.NbBundle.getMessage(TestCategory.class, "TestCategory.buildBeforeTestLabel.text")); // NOI18N

        buildBeforeTest.setModel(runBuildModel());
        buildBeforeTest.setFocusCycleRoot(true);
        buildBeforeTest.setRenderer(runBuildRenderer());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(TestCategory.class, "TestCategory.jLabel1.text")); // NOI18N

        jtregLocation.setText(org.openide.util.NbBundle.getMessage(TestCategory.class, "TestCategory.jtregLocation.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(buildBeforeTestLabel)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(buildBeforeTest, 0, 173, Short.MAX_VALUE)
                    .addComponent(jtregLocation))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(buildBeforeTestLabel)
                    .addComponent(buildBeforeTest, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jtregLocation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(227, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<RunBuild> buildBeforeTest;
    private javax.swing.JLabel buildBeforeTestLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField jtregLocation;
    // End of variables declaration//GEN-END:variables

    private ListCellRenderer<Object> runBuildRenderer() {
        return new DefaultListCellRenderer() {
            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof RunBuild) {
                    value = runBuildDisplayName.getOrDefault(value, String.valueOf(value));
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    private ComboBoxModel<RunBuild> runBuildModel() {
        DefaultComboBoxModel<RunBuild> model = new DefaultComboBoxModel<>();

        for (RunBuild rb : RunBuild.values()) {
            model.addElement(rb);
        }

        return model;
    }

    private static final Map<RunBuild, String> runBuildDisplayName = new EnumMap<RunBuild, String>(RunBuild.class) {{
        put(RunBuild.ALWAYS, "Always");
//        put(RunBuild.SMART, "Smart");
        put(RunBuild.NEVER, "Never");
    }};

    @CompositeCategoryProvider.Registration(projectType=JDKProject.PROJECT_KEY, position=200)
    public static CompositeCategoryProvider createCategoryProvider() {
        return new CompositeCategoryProvider() {
            @Override
            public Category createCategory(Lookup context) {
                if (context.lookup(Settings.class) != null)
                    return Category.create("test", "Test", null);
                return null;
            }
            @Override
            public JComponent createComponent(Category category, Lookup context) {
                Settings settings = context.lookup(Settings.class);
                TestCategory panel = new TestCategory(settings.getRunBuildSetting(), settings.getJTregLocation());
                category.setOkButtonListener(evt -> {
                    settings.setRunBuildSetting((RunBuild) panel.buildBeforeTest.getSelectedItem());
                    settings.setJTregLocation(panel.jtregLocation.getText());
                });
                category.setStoreListener(evt -> settings.flush());
                return panel;
            }
        };
    }
}
