/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * PackagesPanel.java
 *
 * Created on Jan 19, 2010, 3:30:05 PM
 */

package org.netbeans.modules.maven.osgi.customizer;

import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.SelectedItemsTable;
import org.netbeans.modules.maven.api.customizer.support.SelectedItemsTable.SelectedItemsTableModel;
import org.openide.util.HelpCtx;

/**
 *
 * @author dafe
 */
public class PackagesPanel extends javax.swing.JPanel implements HelpCtx.Provider {

    private final SelectedItemsTableModel tableModel;
    private final FelixExportPersister exportPersist;

    /** Creates new form PackagesPanel */
    public PackagesPanel(ModelHandle2 handle, Project prj) {
        exportPersist = new FelixExportPersister(prj, handle);
        tableModel = new SelectedItemsTableModel(exportPersist);

        initComponents();
        if (exportPersist.isIsDefined()) {
            rbCustom.setSelected(true);
            exportTable.setEnabled(true);
        } else {
            rbDefaults.setSelected(true);
            exportTable.setEnabled(false);
        }
        jScrollPane1.getViewport().setBackground(exportTable.getBackground());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        rbDefaults = new javax.swing.JRadioButton();
        rbCustom = new javax.swing.JRadioButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        exportTable = new SelectedItemsTable(tableModel);
        jLabel1 = new javax.swing.JLabel();

        buttonGroup1.add(rbDefaults);
        rbDefaults.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(rbDefaults, org.openide.util.NbBundle.getMessage(PackagesPanel.class, "PackagesPanel.rbDefaults.text")); // NOI18N
        rbDefaults.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbDefaultsActionPerformed(evt);
            }
        });

        buttonGroup1.add(rbCustom);
        org.openide.awt.Mnemonics.setLocalizedText(rbCustom, org.openide.util.NbBundle.getMessage(PackagesPanel.class, "PackagesPanel.rbCustom.text")); // NOI18N
        rbCustom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbCustomActionPerformed(evt);
            }
        });

        exportTable.setEnabled(false);
        jScrollPane1.setViewportView(exportTable);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(PackagesPanel.class, "PackagesPanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(rbDefaults)
                                    .addComponent(rbCustom))
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addComponent(jScrollPane1)))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(35, 35, 35)
                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 504, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rbDefaults)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rbCustom)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void rbDefaultsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbDefaultsActionPerformed
        exportTable.setEnabled(false);
        exportPersist.setDefault(true);
    }//GEN-LAST:event_rbDefaultsActionPerformed

    private void rbCustomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbCustomActionPerformed
        exportTable.setEnabled(true);
        exportPersist.setDefault(false);
    }//GEN-LAST:event_rbCustomActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTable exportTable;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JRadioButton rbCustom;
    private javax.swing.JRadioButton rbDefaults;
    // End of variables declaration//GEN-END:variables
    
    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("maven_settings");
    }
}
