/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.util.Objects;
import org.apache.nifi.nar.NarProperties;

public class NarPersistenceInfo {
    private final File narFile;
    private final NarProperties narProperties;

    public NarPersistenceInfo(File narFile, NarProperties narProperties) {
        this.narFile = Objects.requireNonNull(narFile);
        this.narProperties = Objects.requireNonNull(narProperties);
    }

    public File getNarFile() {
        return this.narFile;
    }

    public NarProperties getNarProperties() {
        return this.narProperties;
    }

    public String toString() {
        return "%s:%s:%s".formatted(this.narProperties.getNarGroup(), this.narProperties.getNarId(), this.narProperties.getNarVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NarPersistenceInfo that = (NarPersistenceInfo)o;
        return Objects.equals(this.narProperties.getCoordinate(), that.narProperties.getCoordinate());
    }

    public int hashCode() {
        return Objects.hash(this.narProperties.getCoordinate());
    }
}

